/************************************************************************************************/
/* Stata User File for H97 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H97.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H97.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H97.DO                                               */
/* The program below will output the Stata dataset H97.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID05 25-26
  str    FAMIDYR 27-28
  str    CPSFAMID 29-30
  str    HIEUIDX 31-37
  byte   FCSZ1231 38-39
  byte   FCRP1231 40-41
  str    RULETR31 42-43
  str    RULETR42 44-45
  str    RULETR53 46-47
  str    RULETR05 48-49
  byte   RUSIZE31 50-51
  byte   RUSIZE42 52-53
  byte   RUSIZE53 54-55
  byte   RUSIZE05 56-57
  byte   RUCLAS31 58-59
  byte   RUCLAS42 60-61
  byte   RUCLAS53 62-63
  byte   RUCLAS05 64-64
  byte   FAMSZE31 65-66
  byte   FAMSZE42 67-68
  byte   FAMSZE53 69-70
  byte   FAMSZE05 71-72
  byte   FMRS1231 73-74
  byte   FAMS1231 75-76
  byte   FAMSZEYR 77-78
  byte   FAMRFPYR 79-80
  byte   REGION31 81-82
  byte   REGION42 83-84
  byte   REGION53 85-86
  byte   REGION05 87-88
  byte   MSA31 89-90
  byte   MSA42 91-92
  byte   MSA53 93-94
  byte   MSA05 95-96
  int    REFPRS31 97-99
  int    REFPRS42 100-102
  int    REFPRS53 103-105
  int    REFPRS05 106-108
  byte   RESP31 109-109
  byte   RESP42 110-110
  byte   RESP53 111-111
  byte   RESP05 112-112
  byte   PROXY31 113-114
  byte   PROXY42 115-116
  byte   PROXY53 117-118
  byte   PROXY05 119-119
  byte   INTVLANG 120-121
  byte   BEGRFD31 122-123
  byte   BEGRFM31 124-125
  int    BEGRFY31 126-129
  byte   ENDRFD31 130-131
  byte   ENDRFM31 132-133
  int    ENDRFY31 134-137
  byte   BEGRFD42 138-139
  byte   BEGRFM42 140-141
  int    BEGRFY42 142-145
  byte   ENDRFD42 146-147
  byte   ENDRFM42 148-149
  int    ENDRFY42 150-153
  byte   BEGRFD53 154-155
  byte   BEGRFM53 156-157
  int    BEGRFY53 158-161
  byte   ENDRFD53 162-163
  byte   ENDRFM53 164-165
  int    ENDRFY53 166-169
  byte   ENDRFD05 170-171
  byte   ENDRFM05 172-173
  int    ENDRFY05 174-177
  byte   KEYNESS 178-178
  byte   INSCOP31 179-179
  byte   INSCOP42 180-180
  byte   INSCOP53 181-181
  byte   INSCOP05 182-182
  byte   INSC1231 183-183
  byte   INSCOPE 184-184
  byte   ELGRND31 185-185
  byte   ELGRND42 186-186
  byte   ELGRND53 187-187
  byte   ELGRND05 188-188
  byte   PSTATS31 189-190
  byte   PSTATS42 191-192
  byte   PSTATS53 193-194
  str    RURSLT31 195-196
  str    RURSLT42 197-198
  str    RURSLT53 199-200
  byte   AGE31X 201-202
  byte   AGE42X 203-204
  byte   AGE53X 205-206
  byte   AGE05X 207-208
  byte   DOBMM 209-210
  int    DOBYY 211-214
  byte   SEX 215-215
  byte   RACEX 216-216
  byte   RACEAX 217-217
  byte   RACEBX 218-218
  byte   RACEWX 219-219
  byte   RACETHNX 220-220
  byte   HISPANX 221-221
  byte   HISPCAT 222-223
  byte   MARRY31X 224-225
  byte   MARRY42X 226-227
  byte   MARRY53X 228-229
  byte   MARRY05X 230-231
  int    SPOUID31 232-234
  int    SPOUID42 235-237
  int    SPOUID53 238-240
  int    SPOUID05 241-243
  byte   SPOUIN31 244-245
  byte   SPOUIN42 246-247
  byte   SPOUIN53 248-249
  byte   SPOUIN05 250-251
  byte   EDUCYR 252-253
  byte   HIDEG 254-255
  byte   FTSTU31X 256-257
  byte   FTSTU42X 258-259
  byte   FTSTU53X 260-261
  byte   FTSTU05X 262-263
  byte   ACTDTY42 264-265
  byte   ACTDTY53 266-267
  byte   RFREL31X 268-269
  byte   RFREL42X 270-271
  byte   RFREL53X 272-273
  byte   RFREL05X 274-275
  int    MOPID31X 276-278
  int    MOPID42X 279-281
  int    MOPID53X 282-284
  int    DAPID31X 285-287
  int    DAPID42X 288-290
  int    DAPID53X 291-293
  byte   SSIDIS05 294-295
  byte   AFDC05 296-297
  byte   FILEDR05 298-299
  byte   WILFIL05 300-301
  byte   FLSTAT05 302-303
  byte   FILER05 304-305
  byte   JTINRU05 306-307
  int    JNTPID05 308-310
  byte   CLMDEP05 311-312
  byte   DEPDNT05 313-314
  byte   DPINRU05 315-316
  byte   DPOTSD05 317-318
  byte   TAXFRM05 319-320
  byte   DEDUCT05 321-322
  double TOTDED05 323-331
  byte   CLMHIP05 332-333
  byte   EICRDT05 334-335
  byte   FOODST05 336-337
  byte   FOODMN05 338-339
  double FOODVL05 340-346
  long   TTLP05X 347-352
  byte   POVCAT05 353-353
  long   WAGEP05X 354-359
  byte   WAGIMP05 360-360
  long   BUSNP05X 361-366
  byte   BUSIMP05 367-367
  long   UNEMP05X 368-372
  byte   UNEIMP05 373-373
  long   WCMPP05X 374-378
  byte   WCPIMP05 379-379
  long   INTRP05X 380-384
  byte   INTIMP05 385-385
  long   DIVDP05X 386-390
  byte   DIVIMP05 391-391
  long   SALEP05X 392-397
  byte   SALIMP05 398-398
  long   PENSP05X 399-403
  byte   PENIMP05 404-404
  long   SSECP05X 405-409
  byte   SSCIMP05 410-410
  long   TRSTP05X 411-416
  byte   TRTIMP05 417-417
  long   VETSP05X 418-422
  byte   VETIMP05 423-423
  long   IRASP05X 424-428
  byte   IRAIMP05 429-429
  long   REFDP05X 430-434
  byte   REFIMP05 435-435
  long   ALIMP05X 436-440
  byte   ALIIMP05 441-441
  long   CHLDP05X 442-446
  byte   CHLIMP05 447-447
  long   CASHP05X 448-452
  byte   CSHIMP05 453-453
  long   SSIP05X 454-458
  byte   SSIIMP05 459-459
  int    PUBP05X 460-463
  byte   PUBIMP05 464-464
  long   OTHRP05X 465-469
  byte   OTHIMP05 470-470
  byte   RTHLTH31 471-472
  byte   RTHLTH42 473-474
  byte   RTHLTH53 475-476
  byte   MNHLTH31 477-478
  byte   MNHLTH42 479-480
  byte   MNHLTH53 481-482
  byte   IADLHP31 483-484
  byte   IADLHP42 485-486
  byte   IADLHP53 487-488
  byte   IADL3M31 489-490
  byte   IADL3M42 491-492
  byte   IADL3M53 493-494
  byte   ADLHLP31 495-496
  byte   ADLHLP42 497-498
  byte   ADLHLP53 499-500
  byte   ADL3MO31 501-502
  byte   ADL3MO42 503-504
  byte   ADL3MO53 505-506
  byte   AIDHLP31 507-508
  byte   AIDHLP53 509-510
  byte   WLKLIM31 511-512
  byte   WLKLIM53 513-514
  byte   LFTDIF31 515-516
  byte   LFTDIF53 517-518
  byte   STPDIF31 519-520
  byte   STPDIF53 521-522
  byte   WLKDIF31 523-524
  byte   WLKDIF53 525-526
  byte   MILDIF31 527-528
  byte   MILDIF53 529-530
  byte   STNDIF31 531-532
  byte   STNDIF53 533-534
  byte   BENDIF31 535-536
  byte   BENDIF53 537-538
  byte   RCHDIF31 539-540
  byte   RCHDIF53 541-542
  byte   FNGRDF31 543-544
  byte   FNGRDF53 545-546
  byte   WLK3MO31 547-548
  byte   WLK3MO53 549-550
  byte   ACTLIM31 551-552
  byte   ACTLIM53 553-554
  byte   WRKLIM31 555-556
  byte   WRKLIM53 557-558
  byte   HSELIM31 559-560
  byte   HSELIM53 561-562
  byte   SCHLIM31 563-564
  byte   SCHLIM53 565-566
  byte   UNABLE31 567-568
  byte   UNABLE53 569-570
  byte   SOCLIM31 571-572
  byte   SOCLIM53 573-574
  byte   COGLIM31 575-576
  byte   COGLIM53 577-578
  byte   WRGLAS42 579-580
  byte   SEEDIF42 581-582
  byte   BLIND42 583-584
  byte   READNW42 585-586
  byte   RECPEP42 587-588
  byte   VISION42 589-590
  byte   HEARAD42 591-592
  byte   HEARDI42 593-594
  byte   DEAF42 595-596
  byte   HEARMO42 597-598
  byte   HEARSM42 599-600
  byte   HEARNG42 601-602
  byte   ANYLIM05 603-604
  byte   LSHLTH42 605-606
  byte   NEVILL42 607-608
  byte   SICEAS42 609-610
  byte   HLTHLF42 611-612
  byte   WRHLTH42 613-614
  byte   CHPMED42 615-616
  byte   CHPMHB42 617-618
  byte   CHPMCN42 619-620
  byte   CHSERV42 621-622
  byte   CHSRHB42 623-624
  byte   CHSRCN42 625-626
  byte   CHLIMI42 627-628
  byte   CHLIHB42 629-630
  byte   CHLICO42 631-632
  byte   CHTHER42 633-634
  byte   CHTHHB42 635-636
  byte   CHTHCO42 637-638
  byte   CHCOUN42 639-640
  byte   CHEMPB42 641-642
  byte   CSHCN42 643-644
  byte   MOMPRO42 645-646
  byte   DADPRO42 647-648
  byte   UNHAP42 649-650
  byte   SCHLBH42 651-652
  byte   HAVFUN42 653-654
  byte   ADUPRO42 655-656
  byte   NERVAF42 657-658
  byte   SIBPRO42 659-660
  byte   KIDPRO42 661-662
  byte   SPRPRO42 663-664
  byte   SCHPRO42 665-666
  byte   HOMEBH42 667-668
  byte   TRBLE42 669-670
  byte   CHILCR42 671-672
  byte   CHILWW42 673-674
  byte   CHRTCR42 675-676
  byte   CHRTWW42 677-678
  byte   CHAPPT42 679-680
  byte   CHNDCR42 681-682
  byte   CHNECP42 683-684
  byte   CHLIST42 685-686
  byte   CHEXPL42 687-688
  byte   CHRESP42 689-690
  byte   CHPRTM42 691-692
  byte   CHHECR42 693-694
  byte   CHSPEC42 695-696
  byte   CHPRRE42 697-698
  byte   MESHGT42 699-700
  byte   WHNHGT42 701-702
  byte   MESWGT42 703-704
  byte   WHNWGT42 705-706
  double CHBMIX42 707-711
  byte   MESVIS42 712-713
  byte   MESBPR42 714-715
  byte   WHNBPR42 716-717
  byte   DENTAL42 718-719
  byte   WHNDEN42 720-721
  byte   EATHLT42 722-723
  byte   WHNEAT42 724-725
  byte   PHYSCL42 726-727
  byte   WHNPHY42 728-729
  byte   SAFEST42 730-731
  byte   WHNSAF42 732-733
  byte   BOOST42 734-735
  byte   WHNBST42 736-737
  byte   LAPBLT42 738-739
  byte   WHNLAP42 740-741
  byte   HELMET42 742-743
  byte   WHNHEL42 744-745
  byte   NOSMOK42 746-747
  byte   WHNSMK42 748-749
  byte   TIMALN42 750-751
  byte   DENTCK53 752-753
  byte   CHOLCK53 754-755
  byte   CHECK53 756-757
  byte   FLUSHT53 758-759
  byte   LSTETH53 760-761
  byte   PSA53 762-763
  byte   HYSTER53 764-765
  byte   PAPSMR53 766-767
  byte   BRSTEX53 768-769
  byte   MAMOGR53 770-771
  byte   STOOL53 772-773
  byte   WHENST53 774-775
  byte   BOWEL53 776-777
  byte   WHNBWL53 778-779
  byte   PHYACT53 780-781
  double BMINDX53 782-786
  byte   SEATBE53 787-788
  byte   SRTHRT53 789-790
  byte   THSYMP53 791-792
  byte   DRTHRT53 793-794
  byte   THANTB53 795-796
  byte   THSWAB53 797-798
  byte   THSYMF53 799-800
  byte   THSWBF53 801-802
  byte   THANTF53 803-804
  byte   DIABDX53 805-806
  byte   ASTHDX53 807-808
  byte   ASSTIL53 809-810
  byte   ASATAK53 811-812
  byte   ASACUT53 813-814
  byte   ASMRCN53 815-816
  byte   ASPREV53 817-818
  byte   ASDALY53 819-820
  byte   ASPKFL53 821-822
  byte   ASEVFL53 823-824
  byte   ASWNFL53 825-826
  byte   HIBPDX53 827-828
  byte   BPMLDX53 829-830
  byte   BPCHEK53 831-832
  byte   BPMONT53 833-834
  byte   CHOLDX53 835-836
  byte   CHLAGE53 837-838
  byte   CHDDX53 839-840
  byte   ANGIDX53 841-842
  byte   MIDX53 843-844
  byte   OHRTDX53 845-846
  byte   STRKDX53 847-848
  byte   EMPHDX53 849-850
  byte   NOFAT53 851-852
  byte   EXRCIS53 853-854
  byte   ASPRIN53 855-856
  byte   NOASPR53 857-858
  byte   STOMCH53 859-860
  byte   JTPAIN53 861-862
  byte   ARTHDX53 863-864
  byte   ARTHTX53 865-866
  byte   SAQELIG 867-867
  int    ADPRX42 868-870
  byte   ADILCR42 871-872
  byte   ADILWW42 873-874
  byte   ADRTCR42 875-876
  byte   ADRTWW42 877-878
  byte   ADAPPT42 879-880
  byte   ADNDCR42 881-882
  byte   ADNECP42 883-884
  byte   ADLIST42 885-886
  byte   ADEXPL42 887-888
  byte   ADRESP42 889-890
  byte   ADPRTM42 891-892
  byte   ADHECR42 893-894
  byte   ADSMOK42 895-896
  byte   ADNSMK42 897-898
  byte   ADDRBP42 899-900
  byte   ADSPEC42 901-902
  byte   ADPRRE42 903-904
  byte   ADGENH42 905-906
  byte   ADDAYA42 907-908
  byte   ADCLIM42 909-910
  byte   ADPALS42 911-912
  byte   ADPWLM42 913-914
  byte   ADMALS42 915-916
  byte   ADMWLM42 917-918
  byte   ADPAIN42 919-920
  byte   ADCAPE42 921-922
  byte   ADNRGY42 923-924
  byte   ADDOWN42 925-926
  byte   ADSOCA42 927-928
  double PCS42 929-933
  double MCS42 934-938
  byte   SFFLAG42 939-940
  byte   ADNERV42 941-942
  byte   ADHOPE42 943-944
  byte   ADREST42 945-946
  byte   ADSAD42 947-948
  byte   ADEFRT42 949-950
  byte   ADWRTH42 951-952
  byte   K6SUM42 953-954
  byte   ADINTR42 955-956
  byte   ADDPRS42 957-958
  double PHQ242 959-963
  byte   ADINSA42 964-965
  byte   ADINSB42 966-967
  byte   ADRISK42 968-969
  byte   ADOVER42 970-971
  byte   ADCMPM42 972-973
  byte   ADCMPD42 974-975
  int    ADCMPY42 976-979
  byte   ADLANG42 980-981
  byte   DSDIA53 982-983
  byte   DSA1C53 984-985
  byte   DSCKFT53 986-987
  byte   DSEY0453 988-989
  byte   DSEY0553 990-991
  byte   DSEY0653 992-993
  byte   DSEB0453 994-995
  byte   DSEYNV53 996-997
  byte   DSKIDN53 998-999
  byte   DSEYPR53 1000-1001
  byte   DSDIET53 1002-1003
  byte   DSMED53 1004-1005
  byte   DSINSU53 1006-1007
  byte   PHONE53 1008-1009
  byte   NURSE53 1010-1011
  byte   VISIT53 1012-1013
  byte   REFER53 1014-1015
  byte   CHLCHK53 1016-1017
  byte   FLSHOT53 1018-1019
  byte   DSPRX53 1020-1021
  int    DDNWRK31 1022-1024
  int    DDNWRK42 1025-1027
  int    DDNWRK53 1028-1030
  int    WKINBD31 1031-1033
  int    WKINBD42 1034-1036
  int    WKINBD53 1037-1039
  int    DDNSCL31 1040-1042
  int    DDNSCL42 1043-1045
  byte   DDNSCL53 1046-1047
  byte   SCLNBD31 1048-1049
  byte   SCLNBD42 1050-1051
  byte   SCLNBD53 1052-1053
  int    DDBDYS31 1054-1056
  int    DDBDYS42 1057-1059
  int    DDBDYS53 1060-1062
  byte   OTHDYS31 1063-1064
  byte   OTHDYS42 1065-1066
  byte   OTHDYS53 1067-1068
  byte   OTHNDD31 1069-1070
  int    OTHNDD42 1071-1073
  int    OTHNDD53 1074-1076
  byte   ACCELI42 1077-1078
  byte   LANGHM42 1079-1080
  byte   ENGHME42 1081-1082
  byte   ENGSPK42 1083-1084
  byte   HAVEUS42 1085-1086
  byte   YNOUSC42 1087-1088
  byte   NOREAS42 1089-1090
  byte   SELDSI42 1091-1092
  byte   NEWARE42 1093-1094
  byte   DKWHRU42 1095-1096
  byte   USCNOT42 1097-1098
  byte   PERSLA42 1099-1100
  byte   DIFFPL42 1101-1102
  byte   INSRPL42 1103-1104
  byte   MYSELF42 1105-1106
  byte   CARECO42 1107-1108
  byte   OTHINS42 1109-1110
  byte   JOBRSN42 1111-1112
  byte   NEWDOC42 1113-1114
  byte   DOCELS42 1115-1116
  byte   NOLIKE42 1117-1118
  byte   HEALTH42 1119-1120
  byte   KNOWDR42 1121-1122
  byte   ONJOB42 1123-1124
  byte   NOGODR42 1125-1126
  byte   TRANS42 1127-1128
  byte   CLINIC42 1129-1130
  byte   OTHREA42 1131-1132
  byte   PROVTY42 1133-1134
  byte   FACLPR42 1135-1136
  byte   PLCTYP42 1137-1138
  byte   GOTOUS42 1139-1140
  byte   TMTKUS42 1141-1142
  byte   DFTOUS42 1143-1144
  byte   TYPEPE42 1145-1146
  byte   LOCATN42 1147-1148
  byte   HSPLAP42 1149-1150
  byte   WHITPR42 1151-1152
  byte   BLCKPR42 1153-1154
  byte   ASIANP42 1155-1156
  byte   NATAMP42 1157-1158
  byte   PACISP42 1159-1160
  byte   OTHRCP42 1161-1162
  byte   GENDRP42 1163-1164
  byte   MINORP42 1165-1166
  byte   PREVEN42 1167-1168
  byte   REFFRL42 1169-1170
  byte   ONGONG42 1171-1172
  byte   PHNREG42 1173-1174
  byte   OFFHOU42 1175-1176
  byte   AFTHOU42 1177-1178
  byte   TREATM42 1179-1180
  byte   RESPCT42 1181-1182
  byte   DECIDE42 1183-1184
  byte   EXPLOP42 1185-1186
  byte   LANGPR42 1187-1188
  byte   MDUNAB42 1189-1190
  byte   MDUNRS42 1191-1192
  byte   MDUNPR42 1193-1194
  byte   MDDLAY42 1195-1196
  byte   MDDLRS42 1197-1198
  byte   MDDLPR42 1199-1200
  byte   DNUNAB42 1201-1202
  byte   DNUNRS42 1203-1204
  byte   DNUNPR42 1205-1206
  byte   DNDLAY42 1207-1208
  byte   DNDLRS42 1209-1210
  byte   DNDLPR42 1211-1212
  byte   PMUNAB42 1213-1214
  byte   PMUNRS42 1215-1216
  byte   PMUNPR42 1217-1218
  byte   PMDLAY42 1219-1220
  byte   PMDLRS42 1221-1222
  byte   PMDLPR42 1223-1224
  byte   EMPST31 1225-1226
  byte   EMPST42 1227-1228
  byte   EMPST53 1229-1230
  byte   RNDFLG31 1231-1232
  byte   MORJOB31 1233-1234
  byte   MORJOB42 1235-1236
  byte   MORJOB53 1237-1238
  byte   EVRWRK 1239-1240
  double HRWG31X 1241-1246
  double HRWG42X 1247-1252
  double HRWG53X 1253-1258
  byte   HRWGIM31 1259-1259
  byte   HRWGIM42 1260-1260
  byte   HRWGIM53 1261-1261
  byte   HRHOW31 1262-1263
  byte   HRHOW42 1264-1265
  byte   HRHOW53 1266-1267
  byte   DIFFWG31 1268-1269
  byte   DIFFWG42 1270-1271
  byte   DIFFWG53 1272-1273
  double NHRWG31 1274-1279
  double NHRWG42 1280-1285
  double NHRWG53 1286-1291
  int    HOUR31 1292-1294
  int    HOUR42 1295-1297
  int    HOUR53 1298-1300
  byte   TEMPJB31 1301-1302
  byte   TEMPJB42 1303-1304
  byte   TEMPJB53 1305-1306
  byte   SSNLJB31 1307-1308
  byte   SSNLJB42 1309-1310
  byte   SSNLJB53 1311-1312
  byte   SELFCM31 1313-1314
  byte   SELFCM42 1315-1316
  byte   SELFCM53 1317-1318
  byte   DISVW31X 1319-1320
  byte   DISVW42X 1321-1322
  byte   DISVW53X 1323-1324
  byte   CHOIC31 1325-1326
  byte   CHOIC42 1327-1328
  byte   CHOIC53 1329-1330
  byte   INDCAT31 1331-1332
  byte   INDCAT42 1333-1334
  byte   INDCAT53 1335-1336
  int    NUMEMP31 1337-1339
  int    NUMEMP42 1340-1342
  int    NUMEMP53 1343-1345
  byte   MORE31 1346-1347
  byte   MORE42 1348-1349
  byte   MORE53 1350-1351
  byte   UNION31 1352-1353
  byte   UNION42 1354-1355
  byte   UNION53 1356-1357
  byte   NWK31 1358-1359
  byte   NWK42 1360-1361
  byte   NWK53 1362-1363
  byte   CHGJ3142 1364-1365
  byte   CHGJ4253 1366-1367
  byte   YCHJ3142 1368-1369
  byte   YCHJ4253 1370-1371
  byte   STJBMM31 1372-1373
  byte   STJBDD31 1374-1375
  int    STJBYY31 1376-1379
  byte   STJBMM42 1380-1381
  byte   STJBDD42 1382-1383
  int    STJBYY42 1384-1387
  byte   STJBMM53 1388-1389
  byte   STJBDD53 1390-1391
  int    STJBYY53 1392-1395
  byte   EVRETIRE 1396-1397
  byte   OCCCAT31 1398-1399
  byte   OCCCAT42 1400-1401
  byte   OCCCAT53 1402-1403
  byte   PAYVAC31 1404-1405
  byte   PAYVAC42 1406-1407
  byte   PAYVAC53 1408-1409
  byte   SICPAY31 1410-1411
  byte   SICPAY42 1412-1413
  byte   SICPAY53 1414-1415
  byte   PAYDR31 1416-1417
  byte   PAYDR42 1418-1419
  byte   PAYDR53 1420-1421
  byte   RETPLN31 1422-1423
  byte   RETPLN42 1424-1425
  byte   RETPLN53 1426-1427
  byte   BSNTY31 1428-1429
  byte   BSNTY42 1430-1431
  byte   BSNTY53 1432-1433
  byte   JOBORG31 1434-1435
  byte   JOBORG42 1436-1437
  byte   JOBORG53 1438-1439
  byte   HELD31X 1440-1441
  byte   HELD42X 1442-1443
  byte   HELD53X 1444-1445
  byte   OFFER31X 1446-1447
  byte   OFFER42X 1448-1449
  byte   OFFER53X 1450-1451
  byte   OFREMP31 1452-1453
  byte   OFREMP42 1454-1455
  byte   OFREMP53 1456-1457
  byte   YNOINS31 1458-1459
  byte   YNOINS42 1460-1461
  byte   YNOINS53 1462-1463
  byte   TRIJA05X 1464-1465
  byte   TRIFE05X 1466-1467
  byte   TRIMA05X 1468-1469
  byte   TRIAP05X 1470-1471
  byte   TRIMY05X 1472-1473
  byte   TRIJU05X 1474-1475
  byte   TRIJL05X 1476-1477
  byte   TRIAU05X 1478-1479
  byte   TRISE05X 1480-1481
  byte   TRIOC05X 1482-1483
  byte   TRINO05X 1484-1485
  byte   TRIDE05X 1486-1487
  byte   MCRJA05 1488-1489
  byte   MCRFE05 1490-1491
  byte   MCRMA05 1492-1493
  byte   MCRAP05 1494-1495
  byte   MCRMY05 1496-1497
  byte   MCRJU05 1498-1499
  byte   MCRJL05 1500-1501
  byte   MCRAU05 1502-1503
  byte   MCRSE05 1504-1505
  byte   MCROC05 1506-1507
  byte   MCRNO05 1508-1509
  byte   MCRDE05 1510-1511
  byte   MCRJA05X 1512-1513
  byte   MCRFE05X 1514-1515
  byte   MCRMA05X 1516-1517
  byte   MCRAP05X 1518-1519
  byte   MCRMY05X 1520-1521
  byte   MCRJU05X 1522-1523
  byte   MCRJL05X 1524-1525
  byte   MCRAU05X 1526-1527
  byte   MCRSE05X 1528-1529
  byte   MCROC05X 1530-1531
  byte   MCRNO05X 1532-1533
  byte   MCRDE05X 1534-1535
  byte   MCDJA05 1536-1537
  byte   MCDFE05 1538-1539
  byte   MCDMA05 1540-1541
  byte   MCDAP05 1542-1543
  byte   MCDMY05 1544-1545
  byte   MCDJU05 1546-1547
  byte   MCDJL05 1548-1549
  byte   MCDAU05 1550-1551
  byte   MCDSE05 1552-1553
  byte   MCDOC05 1554-1555
  byte   MCDNO05 1556-1557
  byte   MCDDE05 1558-1559
  byte   MCDJA05X 1560-1561
  byte   MCDFE05X 1562-1563
  byte   MCDMA05X 1564-1565
  byte   MCDAP05X 1566-1567
  byte   MCDMY05X 1568-1569
  byte   MCDJU05X 1570-1571
  byte   MCDJL05X 1572-1573
  byte   MCDAU05X 1574-1575
  byte   MCDSE05X 1576-1577
  byte   MCDOC05X 1578-1579
  byte   MCDNO05X 1580-1581
  byte   MCDDE05X 1582-1583
  byte   OPAJA05 1584-1585
  byte   OPAFE05 1586-1587
  byte   OPAMA05 1588-1589
  byte   OPAAP05 1590-1591
  byte   OPAMY05 1592-1593
  byte   OPAJU05 1594-1595
  byte   OPAJL05 1596-1597
  byte   OPAAU05 1598-1599
  byte   OPASE05 1600-1601
  byte   OPAOC05 1602-1603
  byte   OPANO05 1604-1605
  byte   OPADE05 1606-1607
  byte   OPBJA05 1608-1609
  byte   OPBFE05 1610-1611
  byte   OPBMA05 1612-1613
  byte   OPBAP05 1614-1615
  byte   OPBMY05 1616-1617
  byte   OPBJU05 1618-1619
  byte   OPBJL05 1620-1621
  byte   OPBAU05 1622-1623
  byte   OPBSE05 1624-1625
  byte   OPBOC05 1626-1627
  byte   OPBNO05 1628-1629
  byte   OPBDE05 1630-1631
  byte   STAJA05 1632-1633
  byte   STAFE05 1634-1635
  byte   STAMA05 1636-1637
  byte   STAAP05 1638-1639
  byte   STAMY05 1640-1641
  byte   STAJU05 1642-1643
  byte   STAJL05 1644-1645
  byte   STAAU05 1646-1647
  byte   STASE05 1648-1649
  byte   STAOC05 1650-1651
  byte   STANO05 1652-1653
  byte   STADE05 1654-1655
  byte   PUBJA05X 1656-1657
  byte   PUBFE05X 1658-1659
  byte   PUBMA05X 1660-1661
  byte   PUBAP05X 1662-1663
  byte   PUBMY05X 1664-1665
  byte   PUBJU05X 1666-1667
  byte   PUBJL05X 1668-1669
  byte   PUBAU05X 1670-1671
  byte   PUBSE05X 1672-1673
  byte   PUBOC05X 1674-1675
  byte   PUBNO05X 1676-1677
  byte   PUBDE05X 1678-1679
  byte   PEGJA05 1680-1681
  byte   PEGFE05 1682-1683
  byte   PEGMA05 1684-1685
  byte   PEGAP05 1686-1687
  byte   PEGMY05 1688-1689
  byte   PEGJU05 1690-1691
  byte   PEGJL05 1692-1693
  byte   PEGAU05 1694-1695
  byte   PEGSE05 1696-1697
  byte   PEGOC05 1698-1699
  byte   PEGNO05 1700-1701
  byte   PEGDE05 1702-1703
  byte   PDKJA05 1704-1705
  byte   PDKFE05 1706-1707
  byte   PDKMA05 1708-1709
  byte   PDKAP05 1710-1711
  byte   PDKMY05 1712-1713
  byte   PDKJU05 1714-1715
  byte   PDKJL05 1716-1717
  byte   PDKAU05 1718-1719
  byte   PDKSE05 1720-1721
  byte   PDKOC05 1722-1723
  byte   PDKNO05 1724-1725
  byte   PDKDE05 1726-1727
  byte   PNGJA05 1728-1729
  byte   PNGFE05 1730-1731
  byte   PNGMA05 1732-1733
  byte   PNGAP05 1734-1735
  byte   PNGMY05 1736-1737
  byte   PNGJU05 1738-1739
  byte   PNGJL05 1740-1741
  byte   PNGAU05 1742-1743
  byte   PNGSE05 1744-1745
  byte   PNGOC05 1746-1747
  byte   PNGNO05 1748-1749
  byte   PNGDE05 1750-1751
  byte   POGJA05 1752-1753
  byte   POGFE05 1754-1755
  byte   POGMA05 1756-1757
  byte   POGAP05 1758-1759
  byte   POGMY05 1760-1761
  byte   POGJU05 1762-1763
  byte   POGJL05 1764-1765
  byte   POGAU05 1766-1767
  byte   POGSE05 1768-1769
  byte   POGOC05 1770-1771
  byte   POGNO05 1772-1773
  byte   POGDE05 1774-1775
  byte   PRSJA05 1776-1777
  byte   PRSFE05 1778-1779
  byte   PRSMA05 1780-1781
  byte   PRSAP05 1782-1783
  byte   PRSMY05 1784-1785
  byte   PRSJU05 1786-1787
  byte   PRSJL05 1788-1789
  byte   PRSAU05 1790-1791
  byte   PRSSE05 1792-1793
  byte   PRSOC05 1794-1795
  byte   PRSNO05 1796-1797
  byte   PRSDE05 1798-1799
  byte   POUJA05 1800-1801
  byte   POUFE05 1802-1803
  byte   POUMA05 1804-1805
  byte   POUAP05 1806-1807
  byte   POUMY05 1808-1809
  byte   POUJU05 1810-1811
  byte   POUJL05 1812-1813
  byte   POUAU05 1814-1815
  byte   POUSE05 1816-1817
  byte   POUOC05 1818-1819
  byte   POUNO05 1820-1821
  byte   POUDE05 1822-1823
  byte   PRIJA05 1824-1825
  byte   PRIFE05 1826-1827
  byte   PRIMA05 1828-1829
  byte   PRIAP05 1830-1831
  byte   PRIMY05 1832-1833
  byte   PRIJU05 1834-1835
  byte   PRIJL05 1836-1837
  byte   PRIAU05 1838-1839
  byte   PRISE05 1840-1841
  byte   PRIOC05 1842-1843
  byte   PRINO05 1844-1845
  byte   PRIDE05 1846-1847
  byte   HPEJA05 1848-1849
  byte   HPEFE05 1850-1851
  byte   HPEMA05 1852-1853
  byte   HPEAP05 1854-1855
  byte   HPEMY05 1856-1857
  byte   HPEJU05 1858-1859
  byte   HPEJL05 1860-1861
  byte   HPEAU05 1862-1863
  byte   HPESE05 1864-1865
  byte   HPEOC05 1866-1867
  byte   HPENO05 1868-1869
  byte   HPEDE05 1870-1871
  byte   HPDJA05 1872-1873
  byte   HPDFE05 1874-1875
  byte   HPDMA05 1876-1877
  byte   HPDAP05 1878-1879
  byte   HPDMY05 1880-1881
  byte   HPDJU05 1882-1883
  byte   HPDJL05 1884-1885
  byte   HPDAU05 1886-1887
  byte   HPDSE05 1888-1889
  byte   HPDOC05 1890-1891
  byte   HPDNO05 1892-1893
  byte   HPDDE05 1894-1895
  byte   HPNJA05 1896-1897
  byte   HPNFE05 1898-1899
  byte   HPNMA05 1900-1901
  byte   HPNAP05 1902-1903
  byte   HPNMY05 1904-1905
  byte   HPNJU05 1906-1907
  byte   HPNJL05 1908-1909
  byte   HPNAU05 1910-1911
  byte   HPNSE05 1912-1913
  byte   HPNOC05 1914-1915
  byte   HPNNO05 1916-1917
  byte   HPNDE05 1918-1919
  byte   HPOJA05 1920-1921
  byte   HPOFE05 1922-1923
  byte   HPOMA05 1924-1925
  byte   HPOAP05 1926-1927
  byte   HPOMY05 1928-1929
  byte   HPOJU05 1930-1931
  byte   HPOJL05 1932-1933
  byte   HPOAU05 1934-1935
  byte   HPOSE05 1936-1937
  byte   HPOOC05 1938-1939
  byte   HPONO05 1940-1941
  byte   HPODE05 1942-1943
  byte   HPSJA05 1944-1945
  byte   HPSFE05 1946-1947
  byte   HPSMA05 1948-1949
  byte   HPSAP05 1950-1951
  byte   HPSMY05 1952-1953
  byte   HPSJU05 1954-1955
  byte   HPSJL05 1956-1957
  byte   HPSAU05 1958-1959
  byte   HPSSE05 1960-1961
  byte   HPSOC05 1962-1963
  byte   HPSNO05 1964-1965
  byte   HPSDE05 1966-1967
  byte   HPRJA05 1968-1969
  byte   HPRFE05 1970-1971
  byte   HPRMA05 1972-1973
  byte   HPRAP05 1974-1975
  byte   HPRMY05 1976-1977
  byte   HPRJU05 1978-1979
  byte   HPRJL05 1980-1981
  byte   HPRAU05 1982-1983
  byte   HPRSE05 1984-1985
  byte   HPROC05 1986-1987
  byte   HPRNO05 1988-1989
  byte   HPRDE05 1990-1991
  byte   INSJA05X 1992-1993
  byte   INSFE05X 1994-1995
  byte   INSMA05X 1996-1997
  byte   INSAP05X 1998-1999
  byte   INSMY05X 2000-2001
  byte   INSJU05X 2002-2003
  byte   INSJL05X 2004-2005
  byte   INSAU05X 2006-2007
  byte   INSSE05X 2008-2009
  byte   INSOC05X 2010-2011
  byte   INSNO05X 2012-2013
  byte   INSDE05X 2014-2015
  byte   PRVEV05 2016-2016
  byte   TRIEV05 2017-2017
  byte   MCREV05 2018-2018
  byte   MCDEV05 2019-2019
  byte   OPAEV05 2020-2020
  byte   OPBEV05 2021-2021
  byte   UNINS05 2022-2022
  byte   INSCOV05 2023-2023
  byte   TRIST31X 2024-2025
  byte   TRIST42X 2026-2027
  byte   TRIST05X 2028-2029
  byte   TRIPR31X 2030-2031
  byte   TRIPR42X 2032-2033
  byte   TRIPR05X 2034-2035
  byte   TRIEX31X 2036-2037
  byte   TRIEX42X 2038-2039
  byte   TRIEX05X 2040-2041
  byte   TRILI31X 2042-2043
  byte   TRILI42X 2044-2045
  byte   TRILI05X 2046-2047
  byte   TRICH42X 2048-2049
  byte   TRICH05X 2050-2051
  byte   MCDHMO31 2052-2053
  byte   MCDHMO42 2054-2055
  byte   MCDHMO05 2056-2057
  byte   MCDMC31 2058-2059
  byte   MCDMC42 2060-2061
  byte   MCDMC05 2062-2063
  byte   PRVHMO31 2064-2065
  byte   PRVHMO42 2066-2067
  byte   PRVHMO05 2068-2069
  byte   PRVMNC31 2070-2071
  byte   PRVMNC42 2072-2073
  byte   PRVMNC05 2074-2075
  byte   PRVDRL31 2076-2077
  byte   PRVDRL42 2078-2079
  byte   PRVDRL05 2080-2081
  byte   PHMONP31 2082-2083
  byte   PHMONP42 2084-2085
  byte   PHMONP05 2086-2087
  byte   PMNCNP31 2088-2089
  byte   PMNCNP42 2090-2091
  byte   PMNCNP05 2092-2093
  byte   PRDRNP31 2094-2095
  byte   PRDRNP42 2096-2097
  byte   PRDRNP05 2098-2099
  byte   PREVCOVR 2100-2101
  byte   COVRMM 2102-2103
  int    COVRYY 2104-2107
  byte   WASESTB 2108-2109
  byte   WASMCARE 2110-2111
  byte   WASMCAID 2112-2113
  byte   WASCHAMP 2114-2115
  byte   WASVA 2116-2117
  byte   WASPRIV 2118-2119
  byte   WASOTGOV 2120-2121
  byte   WASAFDC 2122-2123
  byte   WASSSI 2124-2125
  byte   WASSTAT1 2126-2127
  byte   WASSTAT2 2128-2129
  byte   WASSTAT3 2130-2131
  byte   WASSTAT4 2132-2133
  byte   WASOTHER 2134-2135
  byte   NOINSBEF 2136-2137
  byte   NOINSTM 2138-2139
  byte   NOINUNIT 2140-2141
  byte   MORECOVR 2142-2143
  byte   INSENDMM 2144-2145
  int    INSENDYY 2146-2149
  byte   TRICR31X 2150-2151
  byte   TRICR42X 2152-2153
  byte   TRICR53X 2154-2155
  byte   TRICR05X 2156-2157
  byte   TRIAT31X 2158-2159
  byte   TRIAT42X 2160-2161
  byte   TRIAT53X 2162-2163
  byte   TRIAT05X 2164-2165
  byte   MCAID31 2166-2167
  byte   MCAID42 2168-2169
  byte   MCAID53 2170-2171
  byte   MCAID05 2172-2173
  byte   MCAID31X 2174-2175
  byte   MCAID42X 2176-2177
  byte   MCAID53X 2178-2179
  byte   MCAID05X 2180-2181
  byte   MCARE31 2182-2183
  byte   MCARE42 2184-2185
  byte   MCARE53 2186-2187
  byte   MCARE05 2188-2189
  byte   MCARE31X 2190-2191
  byte   MCARE42X 2192-2193
  byte   MCARE53X 2194-2195
  byte   MCARE05X 2196-2197
  byte   MCDAT31X 2198-2199
  byte   MCDAT42X 2200-2201
  byte   MCDAT53X 2202-2203
  byte   MCDAT05X 2204-2205
  byte   OTPAAT31 2206-2207
  byte   OTPAAT42 2208-2209
  byte   OTPAAT53 2210-2211
  byte   OTPAAT05 2212-2213
  byte   OTPBAT31 2214-2215
  byte   OTPBAT42 2216-2217
  byte   OTPBAT53 2218-2219
  byte   OTPBAT05 2220-2221
  byte   OTPUBA31 2222-2223
  byte   OTPUBA42 2224-2225
  byte   OTPUBA53 2226-2227
  byte   OTPUBA05 2228-2229
  byte   OTPUBB31 2230-2231
  byte   OTPUBB42 2232-2233
  byte   OTPUBB53 2234-2235
  byte   OTPUBB05 2236-2237
  byte   PRIDK31 2238-2239
  byte   PRIDK42 2240-2241
  byte   PRIDK53 2242-2243
  byte   PRIDK05 2244-2245
  byte   PRIEU31 2246-2247
  byte   PRIEU42 2248-2249
  byte   PRIEU53 2250-2251
  byte   PRIEU05 2252-2253
  byte   PRING31 2254-2255
  byte   PRING42 2256-2257
  byte   PRING53 2258-2259
  byte   PRING05 2260-2261
  byte   PRIOG31 2262-2263
  byte   PRIOG42 2264-2265
  byte   PRIOG53 2266-2267
  byte   PRIOG05 2268-2269
  byte   PRIS31 2270-2271
  byte   PRIS42 2272-2273
  byte   PRIS53 2274-2275
  byte   PRIS05 2276-2277
  byte   PRIV31 2278-2279
  byte   PRIV42 2280-2281
  byte   PRIV53 2282-2283
  byte   PRIV05 2284-2285
  byte   PRIVAT31 2286-2287
  byte   PRIVAT42 2288-2289
  byte   PRIVAT53 2290-2291
  byte   PRIVAT05 2292-2293
  byte   PROUT31 2294-2295
  byte   PROUT42 2296-2297
  byte   PROUT53 2298-2299
  byte   PROUT05 2300-2301
  byte   PUB31X 2302-2303
  byte   PUB42X 2304-2305
  byte   PUB53X 2306-2307
  byte   PUB05X 2308-2309
  byte   PUBAT31X 2310-2311
  byte   PUBAT42X 2312-2313
  byte   PUBAT53X 2314-2315
  byte   PUBAT05X 2316-2317
  byte   INS31X 2318-2319
  byte   INS42X 2320-2321
  byte   INS53X 2322-2323
  byte   INS05X 2324-2325
  byte   INSAT31X 2326-2327
  byte   INSAT42X 2328-2329
  byte   INSAT53X 2330-2331
  byte   INSAT05X 2332-2333
  byte   STAPR31 2334-2335
  byte   STAPR42 2336-2337
  byte   STAPR53 2338-2339
  byte   STAPR05 2340-2341
  byte   STPRAT31 2342-2343
  byte   STPRAT42 2344-2345
  byte   STPRAT53 2346-2347
  byte   STPRAT05 2348-2349
  byte   EVRUNINS 2350-2350
  byte   EVRUNAT 2351-2351
  byte   DENTIN31 2352-2353
  byte   DENTIN42 2354-2355
  byte   DENTIN53 2356-2357
  byte   PMEDIN31 2358-2359
  byte   PMEDIN42 2360-2361
  byte   PMEDIN53 2362-2363
  byte   PMEDUP31 2364-2365
  byte   PMEDUP42 2366-2367
  byte   PMEDUP53 2368-2369
  byte   PMEDPY31 2370-2371
  byte   PMEDPY42 2372-2373
  byte   PMEDPY53 2374-2375
  byte   GDCPBM42 2376-2377
  byte   APRTRM42 2378-2379
  byte   APRDLM42 2380-2381
  byte   LKINFM42 2382-2383
  byte   PBINFM42 2384-2385
  byte   CSTSVM42 2386-2387
  byte   PBSVCM42 2388-2389
  byte   PPRWKM42 2390-2391
  byte   PBPWKM42 2392-2393
  byte   RTPLNM42 2394-2395
  byte   GDCPBT42 2396-2397
  byte   APRTRT42 2398-2399
  byte   APRDLT42 2400-2401
  byte   LKINFT42 2402-2403
  byte   PBINFT42 2404-2405
  byte   CSTSVT42 2406-2407
  byte   PBSVCT42 2408-2409
  byte   PPRWKT42 2410-2411
  byte   PBPWKT42 2412-2413
  byte   RTPLNT42 2414-2415
  long   TOTTCH05 2416-2422
  long   TOTEXP05 2423-2428
  long   TOTSLF05 2429-2433
  long   TOTMCR05 2434-2439
  long   TOTMCD05 2440-2445
  long   TOTPRV05 2446-2451
  long   TOTVA05 2452-2456
  long   TOTTRI05 2457-2461
  long   TOTOFD05 2462-2466
  long   TOTSTL05 2467-2471
  long   TOTWCP05 2472-2476
  long   TOTOPR05 2477-2482
  long   TOTOPU05 2483-2487
  long   TOTOSR05 2488-2492
  int    OBTOTV05 2493-2495
  long   OBVTCH05 2496-2502
  long   OBVEXP05 2503-2508
  long   OBVSLF05 2509-2513
  long   OBVMCR05 2514-2518
  long   OBVMCD05 2519-2524
  long   OBVPRV05 2525-2530
  long   OBVVA05 2531-2535
  long   OBVTRI05 2536-2540
  int    OBVOFD05 2541-2544
  long   OBVSTL05 2545-2549
  long   OBVWCP05 2550-2554
  long   OBVOPR05 2555-2559
  long   OBVOPU05 2560-2564
  long   OBVOSR05 2565-2569
  int    OBDRV05 2570-2572
  long   OBDTCH05 2573-2579
  long   OBDEXP05 2580-2585
  long   OBDSLF05 2586-2590
  long   OBDMCR05 2591-2595
  long   OBDMCD05 2596-2601
  long   OBDPRV05 2602-2607
  long   OBDVA05 2608-2612
  int    OBDTRI05 2613-2616
  int    OBDOFD05 2617-2620
  long   OBDSTL05 2621-2625
  long   OBDWCP05 2626-2630
  long   OBDOPR05 2631-2635
  long   OBDOPU05 2636-2640
  long   OBDOSR05 2641-2645
  int    OBOTHV05 2646-2648
  long   OBOTCH05 2649-2654
  long   OBOEXP05 2655-2660
  long   OBOSLF05 2661-2665
  long   OBOMCR05 2666-2670
  long   OBOMCD05 2671-2675
  long   OBOPRV05 2676-2681
  int    OBOVA05 2682-2685
  int    OBOTRI05 2686-2689
  int    OBOOFD05 2690-2693
  int    OBOSTL05 2694-2697
  long   OBOWCP05 2698-2702
  int    OBOOPR05 2703-2706
  int    OBOOPU05 2707-2710
  int    OBOOSR05 2711-2714
  int    OBCHIR05 2715-2717
  long   OBCTCH05 2718-2722
  long   OBCEXP05 2723-2727
  int    OBCSLF05 2728-2731
  int    OBCMCR05 2732-2735
  int    OBCMCD05 2736-2739
  int    OBCPRV05 2740-2743
  int    OBCVA05 2744-2747
  byte   OBCTRI05 2748-2749
  int    OBCOFD05 2750-2752
  int    OBCSTL05 2753-2756
  int    OBCWCP05 2757-2760
  int    OBCOPR05 2761-2764
  int    OBCOPU05 2765-2767
  int    OBCOSR05 2768-2771
  int    OBNURS05 2772-2774
  long   OBNTCH05 2775-2780
  long   OBNEXP05 2781-2785
  long   OBNSLF05 2786-2790
  long   OBNMCR05 2791-2795
  int    OBNMCD05 2796-2799
  long   OBNPRV05 2800-2804
  int    OBNVA05 2805-2808
  int    OBNTRI05 2809-2812
  int    OBNOFD05 2813-2815
  int    OBNSTL05 2816-2818
  int    OBNWCP05 2819-2821
  int    OBNOPR05 2822-2825
  int    OBNOPU05 2826-2828
  int    OBNOSR05 2829-2832
  byte   OBOPTO05 2833-2834
  int    OBETCH05 2835-2838
  int    OBEEXP05 2839-2842
  int    OBESLF05 2843-2846
  int    OBEMCR05 2847-2849
  int    OBEMCD05 2850-2853
  int    OBEPRV05 2854-2857
  int    OBEVA05 2858-2860
  int    OBETRI05 2861-2863
  int    OBEOFD05 2864-2867
  int    OBESTL05 2868-2870
  byte   OBEWCP05 2871-2871
  int    OBEOPR05 2872-2874
  int    OBEOPU05 2875-2877
  int    OBEOSR05 2878-2880
  byte   OBASST05 2881-2882
  long   OBATCH05 2883-2887
  long   OBAEXP05 2888-2892
  int    OBASLF05 2893-2896
  int    OBAMCR05 2897-2900
  long   OBAMCD05 2901-2905
  int    OBAPRV05 2906-2909
  int    OBAVA05 2910-2912
  int    OBATRI05 2913-2916
  int    OBAOFD05 2917-2919
  int    OBASTL05 2920-2922
  int    OBAWCP05 2923-2925
  int    OBAOPR05 2926-2928
  int    OBAOPU05 2929-2932
  int    OBAOSR05 2933-2935
  int    OBTHER05 2936-2938
  long   OBTTCH05 2939-2943
  long   OBTEXP05 2944-2948
  int    OBTSLF05 2949-2952
  int    OBTMCR05 2953-2956
  long   OBTMCD05 2957-2961
  long   OBTPRV05 2962-2966
  int    OBTVA05 2967-2970
  int    OBTTRI05 2971-2974
  byte   OBTOFD05 2975-2976
  int    OBTSTL05 2977-2979
  int    OBTWCP05 2980-2983
  int    OBTOPR05 2984-2987
  int    OBTOPU05 2988-2990
  int    OBTOSR05 2991-2994
  int    OPTOTV05 2995-2997
  long   OPFTCH05 2998-3003
  long   OPFEXP05 3004-3009
  long   OPFSLF05 3010-3014
  long   OPFMCR05 3015-3020
  long   OPFMCD05 3021-3025
  long   OPFPRV05 3026-3031
  long   OPFVA05 3032-3036
  int    OPFTRI05 3037-3040
  long   OPFOFD05 3041-3045
  int    OPFSTL05 3046-3049
  long   OPFWCP05 3050-3054
  long   OPFOPR05 3055-3059
  int    OPFOPU05 3060-3063
  int    OPFOSR05 3064-3067
  long   OPDEXP05 3068-3072
  long   OPDTCH05 3073-3077
  int    OPDSLF05 3078-3081
  int    OPDMCR05 3082-3085
  int    OPDMCD05 3086-3089
  long   OPDPRV05 3090-3094
  int    OPDVA05 3095-3098
  int    OPDTRI05 3099-3101
  byte   OPDOFD05 3102-3103
  int    OPDSTL05 3104-3107
  int    OPDWCP05 3108-3111
  int    OPDOPR05 3112-3115
  int    OPDOPU05 3116-3118
  int    OPDOSR05 3119-3122
  int    OPDRV05 3123-3125
  long   OPVTCH05 3126-3131
  long   OPVEXP05 3132-3136
  long   OPVSLF05 3137-3141
  long   OPVMCR05 3142-3146
  long   OPVMCD05 3147-3151
  long   OPVPRV05 3152-3156
  long   OPVVA05 3157-3161
  int    OPVTRI05 3162-3165
  long   OPVOFD05 3166-3170
  int    OPVSTL05 3171-3174
  long   OPVWCP05 3175-3179
  long   OPVOPR05 3180-3184
  int    OPVOPU05 3185-3188
  int    OPVOSR05 3189-3192
  long   OPSEXP05 3193-3197
  long   OPSTCH05 3198-3202
  int    OPSSLF05 3203-3206
  int    OPSMCR05 3207-3210
  int    OPSMCD05 3211-3214
  long   OPSPRV05 3215-3219
  int    OPSVA05 3220-3222
  int    OPSTRI05 3223-3225
  byte   OPSOFD05 3226-3226
  int    OPSSTL05 3227-3230
  int    OPSWCP05 3231-3234
  int    OPSOPR05 3235-3238
  int    OPSOPU05 3239-3241
  int    OPSOSR05 3242-3245
  int    OPOTHV05 3246-3248
  long   OPOTCH05 3249-3254
  long   OPOEXP05 3255-3260
  int    OPOSLF05 3261-3264
  long   OPOMCR05 3265-3270
  long   OPOMCD05 3271-3275
  long   OPOPRV05 3276-3281
  int    OPOVA05 3282-3285
  int    OPOTRI05 3286-3289
  int    OPOOFD05 3290-3293
  int    OPOSTL05 3294-3297
  long   OPOWCP05 3298-3302
  long   OPOOPR05 3303-3307
  int    OPOOPU05 3308-3311
  int    OPOOSR05 3312-3315
  int    OPPEXP05 3316-3319
  long   OPPTCH05 3320-3324
  int    OPPSLF05 3325-3328
  int    OPPMCR05 3329-3332
  int    OPPMCD05 3333-3336
  int    OPPPRV05 3337-3340
  int    OPPVA05 3341-3344
  int    OPPTRI05 3345-3347
  byte   OPPOFD05 3348-3349
  byte   OPPSTL05 3350-3351
  int    OPPWCP05 3352-3355
  int    OPPOPR05 3356-3359
  int    OPPOPU05 3360-3362
  byte   OPPOSR05 3363-3364
  int    AMCHIR05 3365-3367
  long   AMCTCH05 3368-3372
  long   AMCEXP05 3373-3377
  int    AMCSLF05 3378-3381
  int    AMCMCR05 3382-3385
  int    AMCMCD05 3386-3389
  int    AMCPRV05 3390-3393
  int    AMCVA05 3394-3397
  byte   AMCTRI05 3398-3399
  int    AMCOFD05 3400-3402
  int    AMCSTL05 3403-3406
  int    AMCWCP05 3407-3410
  int    AMCOPR05 3411-3414
  int    AMCOPU05 3415-3417
  int    AMCOSR05 3418-3421
  int    AMNURS05 3422-3424
  long   AMNTCH05 3425-3430
  long   AMNEXP05 3431-3436
  long   AMNSLF05 3437-3441
  long   AMNMCR05 3442-3447
  long   AMNMCD05 3448-3452
  long   AMNPRV05 3453-3457
  int    AMNVA05 3458-3461
  int    AMNTRI05 3462-3465
  int    AMNOFD05 3466-3468
  int    AMNSTL05 3469-3471
  int    AMNWCP05 3472-3475
  int    AMNOPR05 3476-3479
  int    AMNOPU05 3480-3483
  int    AMNOSR05 3484-3487
  byte   AMOPTO05 3488-3489
  int    AMETCH05 3490-3493
  int    AMEEXP05 3494-3497
  int    AMESLF05 3498-3501
  int    AMEMCR05 3502-3504
  int    AMEMCD05 3505-3508
  int    AMEPRV05 3509-3512
  int    AMEVA05 3513-3515
  int    AMETRI05 3516-3518
  int    AMEOFD05 3519-3522
  int    AMESTL05 3523-3525
  byte   AMEWCP05 3526-3526
  int    AMEOPR05 3527-3529
  int    AMEOPU05 3530-3532
  int    AMEOSR05 3533-3535
  byte   AMASST05 3536-3537
  long   AMATCH05 3538-3542
  long   AMAEXP05 3543-3547
  int    AMASLF05 3548-3551
  int    AMAMCR05 3552-3555
  long   AMAMCD05 3556-3560
  int    AMAPRV05 3561-3564
  int    AMAVA05 3565-3568
  int    AMATRI05 3569-3572
  int    AMAOFD05 3573-3575
  int    AMASTL05 3576-3578
  int    AMAWCP05 3579-3581
  int    AMAOPR05 3582-3584
  int    AMAOPU05 3585-3588
  int    AMAOSR05 3589-3591
  int    AMTHER05 3592-3594
  long   AMTTCH05 3595-3600
  long   AMTEXP05 3601-3605
  int    AMTSLF05 3606-3609
  long   AMTMCR05 3610-3614
  long   AMTMCD05 3615-3619
  long   AMTPRV05 3620-3624
  int    AMTVA05 3625-3628
  int    AMTTRI05 3629-3632
  int    AMTOFD05 3633-3635
  int    AMTSTL05 3636-3638
  long   AMTWCP05 3639-3643
  int    AMTOPR05 3644-3647
  int    AMTOPU05 3648-3650
  int    AMTOSR05 3651-3654
  byte   AMTOTC05 3655-3656
  byte   AMDRC05 3657-3657
  byte   ERTOT05 3658-3659
  long   ERFTCH05 3660-3664
  long   ERFEXP05 3665-3669
  long   ERFSLF05 3670-3674
  int    ERFMCR05 3675-3678
  int    ERFMCD05 3679-3682
  long   ERFPRV05 3683-3687
  long   ERFVA05 3688-3692
  long   ERFTRI05 3693-3697
  int    ERFOFD05 3698-3701
  int    ERFSTL05 3702-3705
  int    ERFWCP05 3706-3709
  int    ERFOPR05 3710-3713
  int    ERFOPU05 3714-3717
  int    ERFOSR05 3718-3721
  int    ERDEXP05 3722-3725
  long   ERDTCH05 3726-3730
  int    ERDSLF05 3731-3734
  int    ERDMCR05 3735-3738
  int    ERDMCD05 3739-3742
  int    ERDPRV05 3743-3746
  int    ERDVA05 3747-3749
  int    ERDTRI05 3750-3752
  int    ERDOFD05 3753-3755
  int    ERDSTL05 3756-3758
  int    ERDWCP05 3759-3761
  int    ERDOPR05 3762-3765
  int    ERDOPU05 3766-3768
  int    ERDOSR05 3769-3772
  byte   IPZERO05 3773-3773
  long   ZIFTCH05 3774-3778
  long   ZIFEXP05 3779-3783
  int    ZIFSLF05 3784-3787
  long   ZIFMCR05 3788-3792
  int    ZIFMCD05 3793-3796
  long   ZIFPRV05 3797-3801
  byte   ZIFVA05 3802-3802
  byte   ZIFTRI05 3803-3803
  byte   ZIFOFD05 3804-3804
  byte   ZIFSTL05 3805-3805
  byte   ZIFWCP05 3806-3806
  int    ZIFOPR05 3807-3810
  int    ZIFOPU05 3811-3813
  byte   ZIFOSR05 3814-3814
  long   ZIDEXP05 3815-3819
  long   ZIDTCH05 3820-3824
  int    ZIDSLF05 3825-3828
  int    ZIDMCR05 3829-3832
  int    ZIDMCD05 3833-3835
  int    ZIDPRV05 3836-3839
  byte   ZIDVA05 3840-3840
  byte   ZIDTRI05 3841-3842
  byte   ZIDOFD05 3843-3843
  byte   ZIDSTL05 3844-3844
  byte   ZIDWCP05 3845-3846
  int    ZIDOPR05 3847-3849
  int    ZIDOPU05 3850-3852
  int    ZIDOSR05 3853-3855
  byte   IPDIS05 3856-3857
  long   IPFEXP05 3858-3863
  long   IPFTCH05 3864-3870
  long   IPFSLF05 3871-3875
  long   IPFMCR05 3876-3881
  long   IPFMCD05 3882-3887
  long   IPFPRV05 3888-3893
  long   IPFVA05 3894-3898
  long   IPFTRI05 3899-3903
  long   IPFOFD05 3904-3908
  long   IPFSTL05 3909-3913
  long   IPFWCP05 3914-3918
  long   IPFOPR05 3919-3924
  long   IPFOPU05 3925-3929
  long   IPFOSR05 3930-3934
  long   IPDEXP05 3935-3939
  long   IPDTCH05 3940-3945
  long   IPDSLF05 3946-3950
  long   IPDMCR05 3951-3955
  long   IPDMCD05 3956-3960
  long   IPDPRV05 3961-3965
  int    IPDVA05 3966-3969
  int    IPDTRI05 3970-3973
  int    IPDOFD05 3974-3976
  int    IPDSTL05 3977-3980
  long   IPDWCP05 3981-3985
  int    IPDOPR05 3986-3989
  int    IPDOPU05 3990-3993
  int    IPDOSR05 3994-3997
  int    IPNGTD05 3998-4000
  byte   DVTOT05 4001-4002
  long   DVTTCH05 4003-4007
  long   DVTEXP05 4008-4012
  long   DVTSLF05 4013-4017
  int    DVTMCR05 4018-4021
  long   DVTMCD05 4022-4026
  long   DVTPRV05 4027-4031
  int    DVTVA05 4032-4035
  int    DVTTRI05 4036-4039
  int    DVTOFD05 4040-4043
  int    DVTSTL05 4044-4047
  int    DVTWCP05 4048-4051
  int    DVTOPR05 4052-4055
  int    DVTOPU05 4056-4058
  long   DVTOSR05 4059-4063
  byte   DVGEN05 4064-4065
  long   DVGTCH05 4066-4070
  long   DVGEXP05 4071-4075
  long   DVGSLF05 4076-4080
  int    DVGMCR05 4081-4084
  int    DVGMCD05 4085-4088
  int    DVGPRV05 4089-4092
  int    DVGVA05 4093-4096
  int    DVGTRI05 4097-4100
  int    DVGOFD05 4101-4104
  int    DVGSTL05 4105-4108
  int    DVGWCP05 4109-4111
  int    DVGOPR05 4112-4115
  int    DVGOPU05 4116-4118
  long   DVGOSR05 4119-4123
  byte   DVORTH05 4124-4125
  long   DVOTCH05 4126-4130
  long   DVOEXP05 4131-4135
  long   DVOSLF05 4136-4140
  byte   DVOMCR05 4141-4141
  long   DVOMCD05 4142-4146
  long   DVOPRV05 4147-4151
  int    DVOVA05 4152-4154
  int    DVOTRI05 4155-4158
  byte   DVOOFD05 4159-4159
  int    DVOSTL05 4160-4163
  int    DVOWCP05 4164-4167
  int    DVOOPR05 4168-4171
  int    DVOOPU05 4172-4174
  int    DVOOSR05 4175-4178
  int    HHTOTD05 4179-4181
  int    HHAGD05 4182-4184
  long   HHATCH05 4185-4190
  long   HHAEXP05 4191-4196
  int    HHASLF05 4197-4200
  long   HHAMCR05 4201-4205
  long   HHAMCD05 4206-4211
  long   HHAPRV05 4212-4216
  long   HHAVA05 4217-4221
  int    HHATRI05 4222-4224
  int    HHAOFD05 4225-4227
  long   HHASTL05 4228-4232
  int    HHAWCP05 4233-4235
  int    HHAOPR05 4236-4239
  int    HHAOPU05 4240-4243
  int    HHAOSR05 4244-4247
  int    HHINDD05 4248-4250
  long   HHNTCH05 4251-4255
  long   HHNEXP05 4256-4260
  long   HHNSLF05 4261-4265
  int    HHNMCR05 4266-4269
  long   HHNMCD05 4270-4274
  int    HHNPRV05 4275-4277
  int    HHNVA05 4278-4281
  int    HHNTRI05 4282-4284
  byte   HHNOFD05 4285-4285
  long   HHNSTL05 4286-4290
  byte   HHNWCP05 4291-4291
  int    HHNOPR05 4292-4295
  byte   HHNOPU05 4296-4296
  int    HHNOSR05 4297-4299
  int    HHINFD05 4300-4302
  int    VISEXP05 4303-4306
  int    VISTCH05 4307-4310
  int    VISSLF05 4311-4314
  int    VISMCR05 4315-4317
  int    VISMCD05 4318-4320
  int    VISPRV05 4321-4323
  int    VISVA05 4324-4326
  int    VISTRI05 4327-4329
  int    VISOFD05 4330-4332
  int    VISSTL05 4333-4335
  int    VISWCP05 4336-4338
  int    VISOPR05 4339-4341
  int    VISOPU05 4342-4344
  int    VISOSR05 4345-4347
  long   OTHTCH05 4348-4352
  long   OTHEXP05 4353-4357
  int    OTHSLF05 4358-4361
  long   OTHMCR05 4362-4366
  int    OTHMCD05 4367-4370
  long   OTHPRV05 4371-4375
  int    OTHVA05 4376-4379
  int    OTHTRI05 4380-4382
  int    OTHOFD05 4383-4386
  int    OTHSTL05 4387-4389
  int    OTHWCP05 4390-4392
  int    OTHOPR05 4393-4396
  int    OTHOPU05 4397-4400
  int    OTHOSR05 4401-4404
  int    RXTOT05 4405-4407
  long   RXEXP05 4408-4413
  long   RXSLF05 4414-4418
  long   RXMCR05 4419-4423
  long   RXMCD05 4424-4428
  long   RXPRV05 4429-4434
  long   RXVA05 4435-4439
  long   RXTRI05 4440-4444
  int    RXOFD05 4445-4448
  long   RXSTL05 4449-4453
  int    RXWCP05 4454-4457
  int    RXOPR05 4458-4461
  int    RXOPU05 4462-4465
  int    RXOSR05 4466-4469
  double PERWT05F 4470-4481
  double FAMWT05F 4482-4493
  double FAMWT05C 4494-4505
  double SAQWT05F 4506-4517
  double DIABW05F 4518-4529
  int    VARSTR 4530-4532
  byte   VARPSU 4533-4533
using H97.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID05 "FAMILY ID (STUDENT MERGED IN) - 12/31/05";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY-05";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY-05";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR05 "RU LETTER AS OF 12/31/05";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE05 "RU SIZE AS OF 12/31/05";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS05 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/05";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE05 "RU SIZE INCLUDING STUDENT AS OF 12/31/05";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION05 "CENSUS REGION AS OF 12/31/05";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA05 "MSA AS OF 12/31/05";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS05 "REFERENCE PERSON AS OF 12/31/05";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP05 "1ST RESPONDENT INDICATOR AS OF 12/31/05";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY05 "WAS RESPONDENT A PROXY AS OF 12/31/05";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD05 "2005 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM05 "2005 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY05 "2005 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP05 "INSCOPE - R5/3 START THROUGH 12/31/05";
label variable INSC1231 "INSCOPE STATUS ON 12/31/05";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2005";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND05 "ELIGIBILITY STATUS AS OF 12/31/05";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE05X "AGE AS OF 12/31/05 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY05X "MARITAL STATUS-12/31/05 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID05 "SPOUSE ID - 12/31/05";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN05 "MARITAL STATUS W/SPOUSE PRESENT-12/31/05";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU05X "STUDENT STATUS IF AGES 17-23 - 12/31/05";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL05X "RELATION TO REF PERS-12/31/05 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS05 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC05 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR05 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL05 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT05 "PERSON S FILING STATUS";
label variable FILER05 "PRIMARY OR SECONDARY FILER";
label variable JTINRU05 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID05 "PID OF SECONDARY FILER";
label variable CLMDEP05 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT05 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU05 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD05 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM05 "TAX FORM PERSON WILL FILE";
label variable DEDUCT05 "ITEMIZE OR STANDARD DEDUCTION";
label variable TOTDED05 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP05 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT05 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST05 "DID ANYONE RECEIVE FOOD STAMPS";
label variable FOODMN05 "NUMBER OF MONTHS FOOD STAMPS RECEIVED";
label variable FOODVL05 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP05X "PERSON S TOTAL INCOME";
label variable POVCAT05 "FAMILY INCOME AS PERCENT OF POVERTY LINE";
label variable WAGEP05X "PERSON S WAGE INCOME";
label variable WAGIMP05 "WAGE IMPUTATION FLAG";
label variable BUSNP05X "PERSON S BUSINESS INCOME";
label variable BUSIMP05 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP05X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP05 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP05X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP05 "WORKER S COMP IMPUTATION FLAG";
label variable INTRP05X "PERSON S INTEREST INCOME";
label variable INTIMP05 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP05X "PERSON S DIVIDEND INCOME";
label variable DIVIMP05 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP05X "PERSON S SALES INCOME";
label variable SALIMP05 "SALES INCOME IMPUTATION FLAG";
label variable PENSP05X "PERSON S PENSION INCOME";
label variable PENIMP05 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP05X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP05 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP05X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP05 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP05X "PERSON S VETERANS INCOME";
label variable VETIMP05 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP05X "PERSON S IRA INCOME";
label variable IRAIMP05 "IRA INCOME IMPUTATION FLAG";
label variable REFDP05X "PERSON S REFUND INCOME";
label variable REFIMP05 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP05X "PERSON S ALIMONY INCOME";
label variable ALIIMP05 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP05X "PERSON S CHILD SUPPORT";
label variable CHLIMP05 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP05X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP05 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP05X "PERSON S SSI";
label variable SSIIMP05 "SSI IMPUTATION FLAG";
label variable PUBP05X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP05 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP05X "PERSON S OTHER INCOME";
label variable OTHIMP05 "OTHER INCOME IMPUTAION FLAG";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable IADL3M31 "IADL HELP 3+ MONTHS - RD 3/1";
label variable IADL3M42 "IADL HELP 3+ MONTHS - RD 4/2";
label variable IADL3M53 "IADL HELP 3+ MONTHS - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable ADL3MO31 "ADL HELP 3+ MONTHS - RD 3/1";
label variable ADL3MO42 "ADL HELP 3+ MONTHS - RD 4/2";
label variable ADL3MO53 "ADL HELP 3+ MONTHS - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable WLK3MO31 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 3/1";
label variable WLK3MO53 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM05 "ANY LIMITATION IN P9R3,4,5/P10R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHNECP42 "CAHPS:12MOS:PROB GET NEC CARE(0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHPRRE42 "CAHPS:12MOS:PRB W/RFR TO SPEC(0-17)R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU SHT (>17) - RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable STOOL53 "BLD STOOL TST KIT/CRDS HOME (>17)-RD5/3";
label variable WHENST53 "WHN LST BLD STOOL TST HME KIT (>17)-R5/3";
label variable BOWEL53 "SIGMOIDOSCOPY/COLONOSCOPY (>17) - RD 5/3";
label variable WHNBWL53 "LST SIGMOIDOSCOP/COLONOSCOP (>17)-RD 5/3";
label variable PHYACT53 "MOD/VIG PHYS ACTIV 3X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SRTHRT53 "12MO: SERIOUS SORE THROAT(0-17)-RD 5/3";
label variable THSYMP53 "12MO:SORE THRT/OTH SYMPTMS(0-17)-RD 5/3";
label variable DRTHRT53 "12MO: SEE DR FOR SORE THRT(0-17)-RD 5/3";
label variable THANTB53 "12MO: DR PRES ANTBTC SRE THRT(0-17)RD5/3";
label variable THSWAB53 "12MO: DR GAVE THROAT SWAB(0-17)-RD 5/3";
label variable THSYMF53 "12MO:FAM SAME SRE THRT SYMP (0-17)RD5/3";
label variable THSWBF53 "12MO:DR GAVE FAM THRT SWAB(0-17)-RD5/3";
label variable THANTF53 "12MO:DR PRES FAM ATBTC SR THT(0-17)RD5/3";
label variable DIABDX53 "DIABETES DIAGNOSIS - RD 5/3";
label variable ASTHDX53 "ASTHMA DIAGNOSIS - RD 5/3";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable HIBPDX53 "HIGH BLOOD PRESSURE DIAG (>17) - RD 5/3";
label variable BPMLDX53 "MULT DIAG HIGH BLOOD PRESS (>17) - RD5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHOLDX53 "HIGH CHOLESTEROL DIAGNOSIS (>17) - RD5/3";
label variable CHLAGE53 "HOW OLD WHEN DIAG W/ HGH CHOL - RD5/3";
label variable CHDDX53 "CORONARY HRT DISEASE DIAG (>17) - RD 5/3";
label variable ANGIDX53 "ANGINA DIAGNOSIS (>17) - RD 5/3";
label variable MIDX53 "HEART ATTACK (MI) DIAG (>17) - RD 5/3";
label variable OHRTDX53 "OTHER HEART DISEASE DIAG (>17) - RD 5/3";
label variable STRKDX53 "STROKE DIAGNOSIS (>17) - RD 5/3";
label variable EMPHDX53 "EMPHYSEMA DIAGNOSIS (>17) - RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX53 "ARTHRITIS DIAGNOSIS (>17) - RD 5/3";
label variable ARTHTX53 "ARTHRITIS TREATMNT CURRENTLY (>17)RD5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADNECP42 "SAQ 12MOS: PROBS GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADPRRE42 "SAQ 12MOS: PROBLEM SEEING SPECIALIST";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPD42 "SAQ: DATE COMPLETED - DAY";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C - 2005";
label variable DSCKFT53 "DCS: TIMES FEET CHECKED FOR SORES - 2005";
label variable DSEY0453 "DCS: DILATED EYE EXAM IN 2004";
label variable DSEY0553 "DCS: DILATED EYE EXAM IN 2005";
label variable DSEY0653 "DCS: DILATED EYE EXAM IN 2006";
label variable DSEB0453 "DCS: DILATED EYE EXAM BEFORE 2004";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable PHONE53 "DCS: LEARNED DIAB CARE FROM PHONE CALL";
label variable NURSE53 "DCS: LEARNED DIAB CARE FROM NURSE";
label variable VISIT53 "DCS: LEARNED DIAB CARE FROM HOME VISIT";
label variable REFER53 "DCS: LEARNED DIAB CARE FROM SPECIALIST";
label variable CHLCHK53 "DCS: HOW LONG SINCE CHOLESTEROL CHECK";
label variable FLSHOT53 "DCS: HOW LONG SINCE LAST FLU SHOT";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WORK DAY TO CARE FOR OTH (RD31)";
label variable OTHDYS42 "MISS ANY WORK DAY TO CARE FOR OTH (RD42)";
label variable OTHDYS53 "MISS ANY WORK DAY TO CARE FOR OTH (RD53)";
label variable OTHNDD31 "# DAY MISSED WORK TO CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WORK TO CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WORK TO CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable LANGHM42 "AC01 LANGUAGE SPOKEN MOST IN HOME-R4/2";
label variable ENGHME42 "AC02 HH COMFORTABLE SPEAKNG ENGLISH-R4/2";
label variable ENGSPK42 "AC02A NOT COMFRTBLE SPEAKNG ENGLISH-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable HEALTH42 "AC08 OTH REAS NO USC: HLTH RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable ONJOB42 "AC08 OTH REAS NO USC: DR AT WORK-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable FACLPR42 "AC10 DOES PERS SEE PARTICULAR PROV-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable GOTOUS42 "AC12 HOW DOES PERS GET TO USC PROV-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable DFTOUS42 "AC14 HOW DIFFICULT IS IT GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable LANGPR42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDUNPR42 "AC35 PRB NOT GETTING NCSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable MDDLPR42 "AC39 PRB DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNUNPR42 "AC43 PRB UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable DNDLPR42 "AC47 PRB DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMUNPR42 "AC51 PRB UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable PMDLPR42 "AC55 PRB DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/05";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable YNOINS31 "WHY NOT ELIGIBLE HEALTH INS RD 3/1 CMJ";
label variable YNOINS42 "WHY NOT ELIGIBLE HEALTH INS RD 4/2 CMJ";
label variable YNOINS53 "WHY NOT ELIGIBLE HEALTH INS RD 5/3 CMJ";
label variable TRIJA05X "COVERED BY TRICARE IN JAN05 (ED)";
label variable TRIFE05X "COVERED BY TRICARE IN FEB05 (ED)";
label variable TRIMA05X "COVERED BY TRICARE IN MAR05 (ED)";
label variable TRIAP05X "COVERED BY TRICARE IN APR05 (ED)";
label variable TRIMY05X "COVERED BY TRICARE IN MAY05 (ED)";
label variable TRIJU05X "COVERED BY TRICARE IN JUN05 (ED)";
label variable TRIJL05X "COVERED BY TRICARE IN JUL05 (ED)";
label variable TRIAU05X "COVERED BY TRICARE IN AUG05 (ED)";
label variable TRISE05X "COVERED BY TRICARE IN SEP05 (ED)";
label variable TRIOC05X "COVERED BY TRICARE IN OCT05 (ED)";
label variable TRINO05X "COVERED BY TRICARE IN NOV05 (ED)";
label variable TRIDE05X "COVERED BY TRICARE IN DEC05 (ED)";
label variable MCRJA05 "COVERED BY MEDICARE IN JAN05";
label variable MCRFE05 "COVERED BY MEDICARE IN FEB05";
label variable MCRMA05 "COVERED BY MEDICARE IN MAR05";
label variable MCRAP05 "COVERED BY MEDICARE IN APR05";
label variable MCRMY05 "COVERED BY MEDICARE IN MAY05";
label variable MCRJU05 "COVERED BY MEDICARE IN JUN05";
label variable MCRJL05 "COVERED BY MEDICARE IN JUL05";
label variable MCRAU05 "COVERED BY MEDICARE IN AUG05";
label variable MCRSE05 "COVERED BY MEDICARE IN SEP05";
label variable MCROC05 "COVERED BY MEDICARE IN OCT05";
label variable MCRNO05 "COVERED BY MEDICARE IN NOV05";
label variable MCRDE05 "COVERED BY MEDICARE IN DEC05";
label variable MCRJA05X "COVERED BY MEDICARE IN JAN05 (ED)";
label variable MCRFE05X "COVERED BY MEDICARE IN FEB05 (ED)";
label variable MCRMA05X "COVERED BY MEDICARE IN MAR05 (ED)";
label variable MCRAP05X "COVERED BY MEDICARE IN APR05 (ED)";
label variable MCRMY05X "COVERED BY MEDICARE IN MAY05 (ED)";
label variable MCRJU05X "COVERED BY MEDICARE IN JUN05 (ED)";
label variable MCRJL05X "COVERED BY MEDICARE IN JUL05 (ED)";
label variable MCRAU05X "COVERED BY MEDICARE IN AUG05 (ED)";
label variable MCRSE05X "COVERED BY MEDICARE IN SEP05 (ED)";
label variable MCROC05X "COVERED BY MEDICARE IN OCT05 (ED)";
label variable MCRNO05X "COVERED BY MEDICARE IN NOV05 (ED)";
label variable MCRDE05X "COVERED BY MEDICARE IN DEC05 (ED)";
label variable MCDJA05 "COV BY MEDICAID OR SCHIP IN JAN05";
label variable MCDFE05 "COV BY MEDICAID OR SCHIP IN FEB05";
label variable MCDMA05 "COV BY MEDICAID OR SCHIP IN MAR05";
label variable MCDAP05 "COV BY MEDICAID OR SCHIP IN APR05";
label variable MCDMY05 "COV BY MEDICAID OR SCHIP IN MAY05";
label variable MCDJU05 "COV BY MEDICAID OR SCHIP IN JUN05";
label variable MCDJL05 "COV BY MEDICAID OR SCHIP IN JUL05";
label variable MCDAU05 "COV BY MEDICAID OR SCHIP IN AUG05";
label variable MCDSE05 "COV BY MEDICAID OR SCHIP IN SEP05";
label variable MCDOC05 "COV BY MEDICAID OR SCHIP IN OCT05";
label variable MCDNO05 "COV BY MEDICAID OR SCHIP IN NOV05";
label variable MCDDE05 "COV BY MEDICAID OR SCHIP IN DEC05";
label variable MCDJA05X "COV BY MEDICAID OR SCHIP IN JAN05 (ED)";
label variable MCDFE05X "COV BY MEDICAID OR SCHIP IN FEB05 (ED)";
label variable MCDMA05X "COV BY MEDICAID OR SCHIP IN MAR05 (ED)";
label variable MCDAP05X "COV BY MEDICAID OR SCHIP IN APR05 (ED)";
label variable MCDMY05X "COV BY MEDICAID OR SCHIP IN MAY05 (ED)";
label variable MCDJU05X "COV BY MEDICAID OR SCHIP IN JUN05 (ED)";
label variable MCDJL05X "COV BY MEDICAID OR SCHIP IN JUL05 (ED)";
label variable MCDAU05X "COV BY MEDICAID OR SCHIP IN AUG05 (ED)";
label variable MCDSE05X "COV BY MEDICAID OR SCHIP IN SEP05 (ED)";
label variable MCDOC05X "COV BY MEDICAID OR SCHIP IN OCT05 (ED)";
label variable MCDNO05X "COV BY MEDICAID OR SCHIP IN NOV05 (ED)";
label variable MCDDE05X "COV BY MEDICAID OR SCHIP IN DEC05 (ED)";
label variable OPAJA05 "COV BY OTHER PUBLIC A INS IN JAN05";
label variable OPAFE05 "COV BY OTHER PUBLIC A INS IN FEB05";
label variable OPAMA05 "COV BY OTHER PUBLIC A INS IN MAR05";
label variable OPAAP05 "COV BY OTHER PUBLIC A INS IN APR05";
label variable OPAMY05 "COV BY OTHER PUBLIC A INS IN MAY05";
label variable OPAJU05 "COV BY OTHER PUBLIC A INS IN JUN05";
label variable OPAJL05 "COV BY OTHER PUBLIC A INS IN JUL05";
label variable OPAAU05 "COV BY OTHER PUBLIC A INS IN AUG05";
label variable OPASE05 "COV BY OTHER PUBLIC A INS IN SEP05";
label variable OPAOC05 "COV BY OTHER PUBLIC A INS IN OCT05";
label variable OPANO05 "COV BY OTHER PUBLIC A INS IN NOV05";
label variable OPADE05 "COV BY OTHER PUBLIC A INS IN DEC05";
label variable OPBJA05 "COV BY OTHER PUBLIC B INS IN JAN05";
label variable OPBFE05 "COV BY OTHER PUBLIC B INS IN FEB05";
label variable OPBMA05 "COV BY OTHER PUBLIC B INS IN MAR05";
label variable OPBAP05 "COV BY OTHER PUBLIC B INS IN APR05";
label variable OPBMY05 "COV BY OTHER PUBLIC B INS IN MAY05";
label variable OPBJU05 "COV BY OTHER PUBLIC B INS IN JUN05";
label variable OPBJL05 "COV BY OTHER PUBLIC B INS IN JUL05";
label variable OPBAU05 "COV BY OTHER PUBLIC B INS IN AUG05";
label variable OPBSE05 "COV BY OTHER PUBLIC B INS IN SEP05";
label variable OPBOC05 "COV BY OTHER PUBLIC B INS IN OCT05";
label variable OPBNO05 "COV BY OTHER PUBLIC B INS IN NOV05";
label variable OPBDE05 "COV BY OTHER PUBLIC B INS IN DEC05";
label variable STAJA05 "COVERED BY OTHER STATE PROG IN JAN05";
label variable STAFE05 "COVERED BY OTHER STATE PROG IN FEB05";
label variable STAMA05 "COVERED BY OTHER STATE PROG IN MAR05";
label variable STAAP05 "COVERED BY OTHER STATE PROG IN APR05";
label variable STAMY05 "COVERED BY OTHER STATE PROG IN MAY05";
label variable STAJU05 "COVERED BY OTHER STATE PROG IN JUN05";
label variable STAJL05 "COVERED BY OTHER STATE PROG IN JUL05";
label variable STAAU05 "COVERED BY OTHER STATE PROG IN AUG05";
label variable STASE05 "COVERED BY OTHER STATE PROG IN SEP05";
label variable STAOC05 "COVERED BY OTHER STATE PROG IN OCT05";
label variable STANO05 "COVERED BY OTHER STATE PROG IN NOV05";
label variable STADE05 "COVERED BY OTHER STATE PROG IN DEC05";
label variable PUBJA05X "COVR BY ANY PUBLIC INS IN JAN05 (ED)";
label variable PUBFE05X "COVR BY ANY PUBLIC INS IN FEB05 (ED)";
label variable PUBMA05X "COVR BY ANY PUBLIC INS IN MAR05 (ED)";
label variable PUBAP05X "COVR BY ANY PUBLIC INS IN APR05 (ED)";
label variable PUBMY05X "COVR BY ANY PUBLIC INS IN MAY05 (ED)";
label variable PUBJU05X "COVR BY ANY PUBLIC INS IN JUN05 (ED)";
label variable PUBJL05X "COVR BY ANY PUBLIC INS IN JUL05 (ED)";
label variable PUBAU05X "COVR BY ANY PUBLIC INS IN AUG05 (ED)";
label variable PUBSE05X "COVR BY ANY PUBLIC INS IN SEP05 (ED)";
label variable PUBOC05X "COVR BY ANY PUBLIC INS IN OCT05 (ED)";
label variable PUBNO05X "COVR BY ANY PUBLIC INS IN NOV05 (ED)";
label variable PUBDE05X "COVR BY ANY PUBLIC INS IN DEC05 (ED)";
label variable PEGJA05 "COVERED BY EMPL UNION INS IN JAN05";
label variable PEGFE05 "COVERED BY EMPL UNION INS IN FEB05";
label variable PEGMA05 "COVERED BY EMPL UNION INS IN MAR05";
label variable PEGAP05 "COVERED BY EMPL UNION INS IN APR05";
label variable PEGMY05 "COVERED BY EMPL UNION INS IN MAY05";
label variable PEGJU05 "COVERED BY EMPL UNION INS IN JUN05";
label variable PEGJL05 "COVERED BY EMPL UNION INS IN JUL05";
label variable PEGAU05 "COVERED BY EMPL UNION INS IN AUG05";
label variable PEGSE05 "COVERED BY EMPL UNION INS IN SEP05";
label variable PEGOC05 "COVERED BY EMPL UNION INS IN OCT05";
label variable PEGNO05 "COVERED BY EMPL UNION INS IN NOV05";
label variable PEGDE05 "COVERED BY EMPL UNION INS IN DEC05";
label variable PDKJA05 "COVR BY PRIV INS (SOURCE UNKNWN) JAN05";
label variable PDKFE05 "COVR BY PRIV INS (SOURCE UNKNWN) FEB05";
label variable PDKMA05 "COVR BY PRIV INS (SOURCE UNKNWN) MAR05";
label variable PDKAP05 "COVR BY PRIV INS (SOURCE UNKNWN) APR05";
label variable PDKMY05 "COVR BY PRIV INS (SOURCE UNKNWN) MAY05";
label variable PDKJU05 "COVR BY PRIV INS (SOURCE UNKNWN) JUN05";
label variable PDKJL05 "COVR BY PRIV INS (SOURCE UNKNWN) JUL05";
label variable PDKAU05 "COVR BY PRIV INS (SOURCE UNKNWN) AUG05";
label variable PDKSE05 "COVR BY PRIV INS (SOURCE UNKNWN) SEP05";
label variable PDKOC05 "COVR BY PRIV INS (SOURCE UNKNWN) OCT05";
label variable PDKNO05 "COVR BY PRIV INS (SOURCE UNKNWN) NOV05";
label variable PDKDE05 "COVR BY PRIV INS (SOURCE UNKNWN) DEC05";
label variable PNGJA05 "COVERED BY NONGROUP INS IN JAN05";
label variable PNGFE05 "COVERED BY NONGROUP INS IN FEB05";
label variable PNGMA05 "COVERED BY NONGROUP INS IN MAR05";
label variable PNGAP05 "COVERED BY NONGROUP INS IN APR05";
label variable PNGMY05 "COVERED BY NONGROUP INS IN MAY05";
label variable PNGJU05 "COVERED BY NONGROUP INS IN JUN05";
label variable PNGJL05 "COVERED BY NONGROUP INS IN JUL05";
label variable PNGAU05 "COVERED BY NONGROUP INS IN AUG05";
label variable PNGSE05 "COVERED BY NONGROUP INS IN SEP05";
label variable PNGOC05 "COVERED BY NONGROUP INS IN OCT05";
label variable PNGNO05 "COVERED BY NONGROUP INS IN NOV05";
label variable PNGDE05 "COVERED BY NONGROUP INS IN DEC05";
label variable POGJA05 "COVERED BY OTHER GROUP INS IN JAN05";
label variable POGFE05 "COVERED BY OTHER GROUP INS IN FEB05";
label variable POGMA05 "COVERED BY OTHER GROUP INS IN MAR05";
label variable POGAP05 "COVERED BY OTHER GROUP INS IN APR05";
label variable POGMY05 "COVERED BY OTHER GROUP INS IN MAY05";
label variable POGJU05 "COVERED BY OTHER GROUP INS IN JUN05";
label variable POGJL05 "COVERED BY OTHER GROUP INS IN JUL05";
label variable POGAU05 "COVERED BY OTHER GROUP INS IN AUG05";
label variable POGSE05 "COVERED BY OTHER GROUP INS IN SEP05";
label variable POGOC05 "COVERED BY OTHER GROUP INS IN OCT05";
label variable POGNO05 "COVERED BY OTHER GROUP INS IN NOV05";
label variable POGDE05 "COVERED BY OTHER GROUP INS IN DEC05";
label variable PRSJA05 "COVERED BY SELF-EMP-1 INS IN JAN05";
label variable PRSFE05 "COVERED BY SELF-EMP-1 INS IN FEB05";
label variable PRSMA05 "COVERED BY SELF-EMP-1 INS IN MAR05";
label variable PRSAP05 "COVERED BY SELF-EMP-1 INS IN APR05";
label variable PRSMY05 "COVERED BY SELF-EMP-1 INS IN MAY05";
label variable PRSJU05 "COVERED BY SELF-EMP-1 INS IN JUN05";
label variable PRSJL05 "COVERED BY SELF-EMP-1 INS IN JUL05";
label variable PRSAU05 "COVERED BY SELF-EMP-1 INS IN AUG05";
label variable PRSSE05 "COVERED BY SELF-EMP-1 INS IN SEP05";
label variable PRSOC05 "COVERED BY SELF-EMP-1 INS IN OCT05";
label variable PRSNO05 "COVERED BY SELF-EMP-1 INS IN NOV05";
label variable PRSDE05 "COVERED BY SELF-EMP-1 INS IN DEC05";
label variable POUJA05 "COVERED BY HOLDER OUTSIDE OF RU IN JAN05";
label variable POUFE05 "COVERED BY HOLDER OUTSIDE OF RU IN FEB05";
label variable POUMA05 "COVERED BY HOLDER OUTSIDE OF RU IN MAR05";
label variable POUAP05 "COVERED BY HOLDER OUTSIDE OF RU IN APR05";
label variable POUMY05 "COVERED BY HOLDER OUTSIDE OF RU IN MAY05";
label variable POUJU05 "COVERED BY HOLDER OUTSIDE OF RU IN JUN05";
label variable POUJL05 "COVERED BY HOLDER OUTSIDE OF RU IN JUL05";
label variable POUAU05 "COVERED BY HOLDER OUTSIDE OF RU IN AUG05";
label variable POUSE05 "COVERED BY HOLDER OUTSIDE OF RU IN SEP05";
label variable POUOC05 "COVERED BY HOLDER OUTSIDE OF RU IN OCT05";
label variable POUNO05 "COVERED BY HOLDER OUTSIDE OF RU IN NOV05";
label variable POUDE05 "COVERED BY HOLDER OUTSIDE OF RU IN DEC05";
label variable PRIJA05 "COVERED BY PRIVATE INS IN JAN05";
label variable PRIFE05 "COVERED BY PRIVATE INS IN FEB05";
label variable PRIMA05 "COVERED BY PRIVATE INS IN MAR05";
label variable PRIAP05 "COVERED BY PRIVATE INS IN APR05";
label variable PRIMY05 "COVERED BY PRIVATE INS IN MAY05";
label variable PRIJU05 "COVERED BY PRIVATE INS IN JUN05";
label variable PRIJL05 "COVERED BY PRIVATE INS IN JUL05";
label variable PRIAU05 "COVERED BY PRIVATE INS IN AUG05";
label variable PRISE05 "COVERED BY PRIVATE INS IN SEP05";
label variable PRIOC05 "COVERED BY PRIVATE INS IN OCT05";
label variable PRINO05 "COVERED BY PRIVATE INS IN NOV05";
label variable PRIDE05 "COVERED BY PRIVATE INS IN DEC05";
label variable HPEJA05 "HOLDER OF EMPL UNION INS IN JAN05";
label variable HPEFE05 "HOLDER OF EMPL UNION INS IN FEB05";
label variable HPEMA05 "HOLDER OF EMPL UNION INS IN MAR05";
label variable HPEAP05 "HOLDER OF EMPL UNION INS IN APR05";
label variable HPEMY05 "HOLDER OF EMPL UNION INS IN MAY05";
label variable HPEJU05 "HOLDER OF EMPL UNION INS IN JUN05";
label variable HPEJL05 "HOLDER OF EMPL UNION INS IN JUL05";
label variable HPEAU05 "HOLDER OF EMPL UNION INS IN AUG05";
label variable HPESE05 "HOLDER OF EMPL UNION INS IN SEP05";
label variable HPEOC05 "HOLDER OF EMPL UNION INS IN OCT05";
label variable HPENO05 "HOLDER OF EMPL UNION INS IN NOV05";
label variable HPEDE05 "HOLDER OF EMPL UNION INS IN DEC05";
label variable HPDJA05 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN05";
label variable HPDFE05 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB05";
label variable HPDMA05 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR05";
label variable HPDAP05 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR05";
label variable HPDMY05 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY05";
label variable HPDJU05 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN05";
label variable HPDJL05 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL05";
label variable HPDAU05 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG05";
label variable HPDSE05 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP05";
label variable HPDOC05 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT05";
label variable HPDNO05 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV05";
label variable HPDDE05 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC05";
label variable HPNJA05 "HOLDER OF NONGROUP INS IN JAN05";
label variable HPNFE05 "HOLDER OF NONGROUP INS IN FEB05";
label variable HPNMA05 "HOLDER OF NONGROUP INS IN MAR05";
label variable HPNAP05 "HOLDER OF NONGROUP INS IN APR05";
label variable HPNMY05 "HOLDER OF NONGROUP INS IN MAY05";
label variable HPNJU05 "HOLDER OF NONGROUP INS IN JUN05";
label variable HPNJL05 "HOLDER OF NONGROUP INS IN JUL05";
label variable HPNAU05 "HOLDER OF NONGROUP INS IN AUG05";
label variable HPNSE05 "HOLDER OF NONGROUP INS IN SEP05";
label variable HPNOC05 "HOLDER OF NONGROUP INS IN OCT05";
label variable HPNNO05 "HOLDER OF NONGROUP INS IN NOV05";
label variable HPNDE05 "HOLDER OF NONGROUP INS IN DEC05";
label variable HPOJA05 "HOLDER OF OTHER GROUP INS IN JAN05";
label variable HPOFE05 "HOLDER OF OTHER GROUP INS IN FEB05";
label variable HPOMA05 "HOLDER OF OTHER GROUP INS IN MAR05";
label variable HPOAP05 "HOLDER OF OTHER GROUP INS IN APR05";
label variable HPOMY05 "HOLDER OF OTHER GROUP INS IN MAY05";
label variable HPOJU05 "HOLDER OF OTHER GROUP INS IN JUN05";
label variable HPOJL05 "HOLDER OF OTHER GROUP INS IN JUL05";
label variable HPOAU05 "HOLDER OF OTHER GROUP INS IN AUG05";
label variable HPOSE05 "HOLDER OF OTHER GROUP INS IN SEP05";
label variable HPOOC05 "HOLDER OF OTHER GROUP INS IN OCT05";
label variable HPONO05 "HOLDER OF OTHER GROUP INS IN NOV05";
label variable HPODE05 "HOLDER OF OTHER GROUP INS IN DEC05";
label variable HPSJA05 "HOLDER OF SELF-EMP-1 INS IN JAN05";
label variable HPSFE05 "HOLDER OF SELF-EMP-1 INS IN FEB05";
label variable HPSMA05 "HOLDER OF SELF-EMP-1 INS IN MAR05";
label variable HPSAP05 "HOLDER OF SELF-EMP-1 INS IN APR05";
label variable HPSMY05 "HOLDER OF SELF-EMP-1 INS IN MAY05";
label variable HPSJU05 "HOLDER OF SELF-EMP-1 INS IN JUN05";
label variable HPSJL05 "HOLDER OF SELF-EMP-1 INS IN JUL05";
label variable HPSAU05 "HOLDER OF SELF-EMP-1 INS IN AUG05";
label variable HPSSE05 "HOLDER OF SELF-EMP-1 INS IN SEP05";
label variable HPSOC05 "HOLDER OF SELF-EMP-1 INS IN OCT05";
label variable HPSNO05 "HOLDER OF SELF-EMP-1 INS IN NOV05";
label variable HPSDE05 "HOLDER OF SELF-EMP-1 INS IN DEC05";
label variable HPRJA05 "HOLDER OF PRIVATE INSURANCE IN JAN05";
label variable HPRFE05 "HOLDER OF PRIVATE INSURANCE IN FEB05";
label variable HPRMA05 "HOLDER OF PRIVATE INSURANCE IN MAR05";
label variable HPRAP05 "HOLDER OF PRIVATE INSURANCE IN APR05";
label variable HPRMY05 "HOLDER OF PRIVATE INSURANCE IN MAY05";
label variable HPRJU05 "HOLDER OF PRIVATE INSURANCE IN JUN05";
label variable HPRJL05 "HOLDER OF PRIVATE INSURANCE IN JUL05";
label variable HPRAU05 "HOLDER OF PRIVATE INSURANCE IN AUG05";
label variable HPRSE05 "HOLDER OF PRIVATE INSURANCE IN SEP05";
label variable HPROC05 "HOLDER OF PRIVATE INSURANCE IN OCT05";
label variable HPRNO05 "HOLDER OF PRIVATE INSURANCE IN NOV05";
label variable HPRDE05 "HOLDER OF PRIVATE INSURANCE IN DEC05";
label variable INSJA05X "COVR BY HOSP/MED INS IN JAN05 (ED)";
label variable INSFE05X "COVR BY HOSP/MED INS IN FEB05 (ED)";
label variable INSMA05X "COVR BY HOSP/MED INS IN MAR05 (ED)";
label variable INSAP05X "COVR BY HOSP/MED INS IN APR05 (ED)";
label variable INSMY05X "COVR BY HOSP/MED INS IN MAY05 (ED)";
label variable INSJU05X "COVR BY HOSP/MED INS IN JUN05 (ED)";
label variable INSJL05X "COVR BY HOSP/MED INS IN JUL05 (ED)";
label variable INSAU05X "COVR BY HOSP/MED INS IN AUG05 (ED)";
label variable INSSE05X "COVR BY HOSP/MED INS IN SEP05 (ED)";
label variable INSOC05X "COVR BY HOSP/MED INS IN OCT05 (ED)";
label variable INSNO05X "COVR BY HOSP/MED INS IN NOV05 (ED)";
label variable INSDE05X "COVR BY HOSP/MED INS IN DEC05 (ED)";
label variable PRVEV05 "EVER HAVE PRIVATE INSURANCE DURING 05";
label variable TRIEV05 "EVER HAVE TRICARE DURING 05";
label variable MCREV05 "EVER HAVE MEDICARE DURING 05 (ED)";
label variable MCDEV05 "EVER HAVE MEDICAID/SCHIP DURING 05 (ED)";
label variable OPAEV05 "EVER HAVE OTHER PUBLIC A INS DURING 05";
label variable OPBEV05 "EVER HAVE OTHER PUBLIC B INS DURING 05";
label variable UNINS05 "UNINSURED ALL OF 05";
label variable INSCOV05 "HEALTH INSURANCE COVERAGE INDICATOR 05";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST05X "COVERED BY TRICARE STANDARD - 12/31/05";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR05X "COVERED BY TRICARE PRIME - 12/31/05";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX05X "COVERED BY TRICARE EXTRA - 12/31/05";
label variable TRILI31X "COVERED BY TRICARE FOR LIFE - R3/1";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI05X "COVERED BY TRICARE FOR LIFE - 12/31/05";
label variable TRICH42X "COVERED BY TRICARE CHAMPVA - R4/2";
label variable TRICH05X "COVERED BY TRICARE CHAMPVA - 12/31/05";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO05 "COVRED BY MEDICAID OR SCHIP HMO-12/31/05";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC05 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/05";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO05 "COVERED BY PRIVATE HMO - 12/31/05";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC05 "COVERED BY PRIV GATEKEEPER PLAN-12/31/05";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PRVDRL05 "COV BY PRIV PLAN W/DOCTOR LIST-12/31/05";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PHMONP05 "COV BY HMO-PAYS NON-PLAN DRS - 12/31/05";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PMNCNP05 "COV BY GATEKP-PAYS NON-PLAN DRS-12/31/05";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP05 "COV BY DR LIST-PAYS NON-PLAN DR-12/31/05";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 10 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 10 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 10 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 10 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 10 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 10 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 10 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 10 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 10 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 10 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 10 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 10 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 10 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 10 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 10 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 10 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 10 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 10 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PN 10 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 10 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 10 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 10 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 10 ONLY";
label variable TRICR31X "COV BY TRICARE - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICARE - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICARE 12-31/R3 INT DT (ED)";
label variable TRICR05X "COV BY TRICARE - 12/31/05 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE - R5/3";
label variable TRIAT05X "ANY TIME COV TRICARE - 12/31/05";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID05 "COV BY MEDICAID OR SCHIP - 12/31/05";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID05X "COV BY MEDICAID OR SCHIP - 12/31/05 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE05 "COV BY MEDICARE - 12/31/05";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE05X "COV BY MEDICARE - 12/31/05 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT05X "ANY TIME COV MEDICAID OR SCHIP-12/31/05";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT05 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/05";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT05 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/05";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA05 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/05";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB05 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/05";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK05 "COV BY PRIV INS (DK PLAN) - 12/31/05";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU05 "COV BY EMPL/UNION GRP INS - 12/31/05";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING05 "COV BY NON-GROUP INS - 12/31/05";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG05 "COV BY OTHER GROUP INS - 12/31/05";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS05 "COV BY SELF-EMP-1 INS - 12/31/05";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV05 "COV BY PRIV HLTH INS - 12/31/05";
label variable PRIVAT31 "ANY TIME COV PRIVATE INS - R3/1";
label variable PRIVAT42 "ANY TIME COV PRIVATE INS - R4/2";
label variable PRIVAT53 "ANY TIME COV PRIVATE INS - R5/3";
label variable PRIVAT05 "ANY TIME COV PRIVATE INS - 12/31/05";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT05 "COV BY SOMEONE OUT OF RU - 12/31/05";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB05X "COV BY PUBLIC INS - 12/31/05 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV BY PUBLIC - R5/3";
label variable PUBAT05X "ANY TIME COV BY PUBLIC - 12/31/05";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS05X "INSURED - 12/31/05 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT05X "INSURED ANY TIME IN R3 UNTIL 12/31/05/R5";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR05 "COV BY STATE-SPEC PROG - 12/31/05";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COVERAGE BY STATE INS - R5/3";
label variable STPRAT05 "ANY TIME COV BY STATE INS - 12/31/05";
label variable EVRUNINS "EVER UNINSURED IN 05 USING PRIV/PUBX";
label variable EVRUNAT "EVER UNINSURED IN 05 USING PRIVAT/PUBATX";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable GDCPBM42 "MCAID/O PUB: PROB GETTING PERS DOC-R4/2";
label variable APRTRM42 "MCAID/O PUB: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLM42 "MCAID/O PUB: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFM42 "MCAID/O PUB: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFM42 "MCAID/O PUB: PROBLEM FINDING INFO-R4/2";
label variable CSTSVM42 "MCAID/O PUB: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCM42 "MCAID/O PUB: PROB GET HELP FR CSRVC-R4/2";
label variable PPRWKM42 "MCAID/O PUB:FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKM42 "MCAID/O PUB: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNM42 "MCAID/O PUB: RATE EXPERIENCE W PLAN-R4/2";
label variable GDCPBT42 "TRICR/CHAMV: PROB GETTING PERS DOC-R4/2";
label variable APRTRT42 "TRICR/CHAMV: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLT42 "TRICR/CHAMV: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFT42 "TRICR/CHAMV: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFT42 "TRICR/CHAMV: PROBLEM FINDING INFO-R4/2";
label variable CSTSVT42 "TRICR/CHAMV: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCT42 "TRICR/CHAMV: PROB GET HELP FR CSRVC-R4/2";
label variable PPRWKT42 "TRICR/CHAMV:FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKT42 "TRICR/CHAMV: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNT42 "TRICR/CHAMV: RATE EXPERIENCE W PLAN-R4/2";
label variable TOTTCH05 "TOTAL HEALTH CARE CHARGES 05, EXCL RX";
label variable TOTEXP05 "TOTAL HEALTH CARE EXP 05";
label variable TOTSLF05 "TOTAL AMT PAID BY SELF/FAMILY 05";
label variable TOTMCR05 "TOTAL AMT PAID BY MEDICARE 05";
label variable TOTMCD05 "TOTAL AMT PAID BY MEDICAID 05";
label variable TOTPRV05 "TOTAL AMT PAID BY PRIVATE INS 05";
label variable TOTVA05 "TOTAL AMT PAID BY VA 05";
label variable TOTTRI05 "TOTAL AMT PAID BY TRICARE 05";
label variable TOTOFD05 "TOTAL AMT PAID BY OTHER FEDERAL 05";
label variable TOTSTL05 "TOTAL AMT PAID BY OTH ST/LOCAL 05";
label variable TOTWCP05 "TOTAL AMT PAID BY WORKERS COMP 05";
label variable TOTOPR05 "TOTAL AMT PAID BY OTHER PRIVATE 05";
label variable TOTOPU05 "TOTAL AMT PAID BY OTHER PUBLIC 05";
label variable TOTOSR05 "TOTAL AMT PAID BY OTHER SOURCES 05";
label variable OBTOTV05 "# OFFICE-BASED PROVIDER VISITS 05";
label variable OBVTCH05 "OFFICE-BASED PROVIDER VISIT CHARGES 05";
label variable OBVEXP05 "TOTAL OFFICE-BASED EXP 05";
label variable OBVSLF05 "ALL OFFICE VISITS -SELF/FAMILY AMT 05";
label variable OBVMCR05 "ALL OFFICE VISITS -MEDICARE AMT 05";
label variable OBVMCD05 "ALL OFFICE VISITS -MEDICAID AMT 05";
label variable OBVPRV05 "ALL OFFICE VISITS -PRIVATE INS AMT 05";
label variable OBVVA05 "ALL OFFICE VISITS-VA AMT 05";
label variable OBVTRI05 "ALL OFFICE VISITS-TRICARE AMT 05";
label variable OBVOFD05 "ALL OFFICE VISITS-OTHER FEDERAL AMT 05";
label variable OBVSTL05 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 05";
label variable OBVWCP05 "ALL OFFICE VISITS -WORKERS COMP AMT 05";
label variable OBVOPR05 "ALL OFFICE VISITS - OTH PRIVATE AMT 05";
label variable OBVOPU05 "ALL OFFICE VISITS - OTH PUBLIC AMT 05";
label variable OBVOSR05 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 05";
label variable OBDRV05 "# OFFICE-BASED PHYSICIAN VISITS 05";
label variable OBDTCH05 "OFFICE-BASED PHYSICIAN VISIT CHARGES 05";
label variable OBDEXP05 "TOTAL OFF-BASED DR EXP 05";
label variable OBDSLF05 "DR OFFICE VISITS -SELF/FAMILY AMT 05";
label variable OBDMCR05 "DR OFFICE VISITS -MEDICARE AMT 05";
label variable OBDMCD05 "DR OFFICE VISITS -MEDICAID AMT 05";
label variable OBDPRV05 "DR OFFICE VISITS -PRIVATE INS AMT 05";
label variable OBDVA05 "DR OFFICE VISITS -VA AMT 05";
label variable OBDTRI05 "DR OFFICE VISITS -TRICARE AMT 05";
label variable OBDOFD05 "DR OFFICE VISITS -OTHER FEDERAL AMT 05";
label variable OBDSTL05 "DR OFFICE VISITS -OTH ST/LOCAL AMT 05";
label variable OBDWCP05 "DR OFFICE VISITS -WORKERS COMP AMT 05";
label variable OBDOPR05 "DR OFFICE VISITS - OTH PRIVATE AMT 05";
label variable OBDOPU05 "DR OFFICE VISITS - OTH PUBLIC AMT 05";
label variable OBDOSR05 "DR OFF VSTS - OTH UNCLASS SRCE AMT 05";
label variable OBOTHV05 "# OFFICE-BASED NON-PHYSICAN VISITS 05";
label variable OBOTCH05 "OFFICE-BASED NON-DR VISIT CHARGES 05";
label variable OBOEXP05 "TOTAL OFF-BASED NON-DR EXP 05";
label variable OBOSLF05 "NON-DR OFF VISTS -SELF/FAMILY AMT 05";
label variable OBOMCR05 "NON-DR OFF VISTS -MEDICARE AMT 05";
label variable OBOMCD05 "NON-DR OFF VISTS -MEDICAID AMT 05";
label variable OBOPRV05 "NON-DR OFF VISTS -PRIVATE INS AMT 05";
label variable OBOVA05 "NON-DR OFF VISTS -VA AMT 05";
label variable OBOTRI05 "NON-DR OFF VISTS -TRICARE AMT 05";
label variable OBOOFD05 "NON-DR OFF VISTS -OTHER FEDERAL AMT 05";
label variable OBOSTL05 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 05";
label variable OBOWCP05 "NON-DR OFF VISTS -WORKERS COMP AMT 05";
label variable OBOOPR05 "NON-DR OFF VISTS - OTH PRIVATE AMT 05";
label variable OBOOPU05 "NON-DR OFF VISTS - OTH PUBLIC AMT 05";
label variable OBOOSR05 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 05";
label variable OBCHIR05 "# OFFICE-BASED CHIROPRACTOR VISITS 05";
label variable OBCTCH05 "OFFICE-BASED CHIRO VISIT CHARGES 05";
label variable OBCEXP05 "TOTAL OFF-BASED CHIRO EXP 05";
label variable OBCSLF05 "CHIRO OFF VISITS -SELF/FAMILY AMT 05";
label variable OBCMCR05 "CHIRO OFF VISITS -MEDICARE AMT 05";
label variable OBCMCD05 "CHIRO OFF VISITS -MEDICAID AMT 05";
label variable OBCPRV05 "CHIRO OFF VISITS -PRIVATE INS AMT 05";
label variable OBCVA05 "CHIRO OFF VISITS -VA AMT 05";
label variable OBCTRI05 "CHIRO OFF VISITS -TRICARE AMT 05";
label variable OBCOFD05 "CHIRO OFF VISITS -OTHER FEDERAL AMT 05";
label variable OBCSTL05 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 05";
label variable OBCWCP05 "CHIRO OFF VISITS -WORKERS COMP AMT 05";
label variable OBCOPR05 "CHIRO OFF VISTS - OTHR PRIVATE AMT 05";
label variable OBCOPU05 "CHIRO OFF VISTS - OTHR PUBLIC AMT 05";
label variable OBCOSR05 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 05";
label variable OBNURS05 "# OFF-BASED NURSE/PRACTITIONER VISITS 05";
label variable OBNTCH05 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 05";
label variable OBNEXP05 "TOTAL OFF-BASED NURSE/PRAC 05";
label variable OBNSLF05 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 05";
label variable OBNMCR05 "NURSE/PRAC OFF VISITS -MEDICARE AMT 05";
label variable OBNMCD05 "NURSE/PRAC OFF VSTS -MEDICAID AMT 05";
label variable OBNPRV05 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 05";
label variable OBNVA05 "NURSE/PRAC OFF VSTS -VA AMT 05";
label variable OBNTRI05 "NURSE/PRAC OFF VSTS -TRICARE AMT 05";
label variable OBNOFD05 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 05";
label variable OBNSTL05 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 05";
label variable OBNWCP05 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 05";
label variable OBNOPR05 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 05";
label variable OBNOPU05 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 05";
label variable OBNOSR05 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 05";
label variable OBOPTO05 "# OFF-BASED OPTOMETRIST VISITS 05";
label variable OBETCH05 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 05";
label variable OBEEXP05 "TOTAL OFF-BASED OPOTMETRIST EXP 05";
label variable OBESLF05 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 05";
label variable OBEMCR05 "OPTOMETRIST OFF VSTS -MEDICARE AMT 05";
label variable OBEMCD05 "OPTOMETRIST OFF VSTS -MEDICAID AMT 05";
label variable OBEPRV05 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 05";
label variable OBEVA05 "OPTOMETRIST OFF VSTS -VA AMT 05";
label variable OBETRI05 "OPTOMETRIST OFF VSTS -TRICARE AMT 05";
label variable OBEOFD05 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 05";
label variable OBESTL05 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 05";
label variable OBEWCP05 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 05";
label variable OBEOPR05 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 05";
label variable OBEOPU05 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 05";
label variable OBEOSR05 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 05";
label variable OBASST05 "# OFF-BASED PHYSICIAN ASSIST VISITS 05";
label variable OBATCH05 "OFFICE-BASED PHYS ASST VISIT CHARGES 05";
label variable OBAEXP05 "TOTAL OFF-BASED PHYS ASS T EXP 05";
label variable OBASLF05 "PHYS ASS T OFF VSTS -SELF/FAMILY AMT 05";
label variable OBAMCR05 "PHYS ASS T OFF VSTS -MEDICARE AMT 05";
label variable OBAMCD05 "PHYS ASS T OFF VSTS -MEDICAID AMT 05";
label variable OBAPRV05 "PHYS ASS T OFF VSTS -PRIVATE INS AMT 05";
label variable OBAVA05 "PHYS ASS T OFF VSTS -VA AMT 05";
label variable OBATRI05 "PHYS ASS T OFF VSTS -TRICARE AMT 05";
label variable OBAOFD05 "PHYS ASS T OFF VSTS -OTHER FED AMT 05";
label variable OBASTL05 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 05";
label variable OBAWCP05 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 05";
label variable OBAOPR05 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 05";
label variable OBAOPU05 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 05";
label variable OBAOSR05 "P A OFF VSTS - OTH UNCLASS SRCE AMT 05";
label variable OBTHER05 "# OFF-BASED PT/OT VISITS 05";
label variable OBTTCH05 "OFFICE-BASED PT/OC VISIT CHARGES 05";
label variable OBTEXP05 "TOT OFF-BASED PT EXP 05";
label variable OBTSLF05 "PT/OT OFF VISITS -SELF/FAMILY AMT 05";
label variable OBTMCR05 "PT/OT OFF VISITS -MEDICARE AMT 05";
label variable OBTMCD05 "PT/OT OFF VISITS -MEDICAID AMT 05";
label variable OBTPRV05 "PT/OT OFF VISITS -PRIVATE INS AMT 05";
label variable OBTVA05 "PT/OT OFF VISITS -VA AMT 05";
label variable OBTTRI05 "PT/OT OFF VISITS -TRICARE AMT 05";
label variable OBTOFD05 "PT/OT OFF VISITS -OTHER FED AMT 05";
label variable OBTSTL05 "PT/OT OFF VISITS -OTH ST/LOCL AMT 05";
label variable OBTWCP05 "PT/OT OFF VISITS -WORKERS COMP AMT 05";
label variable OBTOPR05 "PT/OT OFF VISITS - OTH PRIVATE AMT 05";
label variable OBTOPU05 "PT/OT OFF VISITS - OTH PUBLIC AMT 05";
label variable OBTOSR05 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 05";
label variable OPTOTV05 "# OUTPATIENT DEPT PROVIDER VISITS 05";
label variable OPFTCH05 "OPD PROVIDER VISIT CHARGES - FAC 05";
label variable OPFEXP05 "TOTAL OUTPATIENT FACILITY EXP 05";
label variable OPFSLF05 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 05";
label variable OPFMCR05 "ALL OPD VISITS-MEDICARE AMT-FAC 05";
label variable OPFMCD05 "ALL OPD VISITS-MEDICAID AMT-FAC 05";
label variable OPFPRV05 "ALL OPD VISITS-PRIV INS AMT-FAC 05";
label variable OPFVA05 "ALL OPD VISITS-VA AMT-FAC 05";
label variable OPFTRI05 "ALL OPD VISITS-TRICARE AMT-FAC 05";
label variable OPFOFD05 "ALL OPD VISITS-OTHER FED AMT-FAC 05";
label variable OPFSTL05 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 05";
label variable OPFWCP05 "ALL OPD VISITS-WORKERS COMP AMT-FAC 05";
label variable OPFOPR05 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 05";
label variable OPFOPU05 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 05";
label variable OPFOSR05 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 05";
label variable OPDEXP05 "TOTAL OUTPATIENT PROVIDER EXP 05";
label variable OPDTCH05 "OPD PROVIDER VISIT CHARGES - DR 05";
label variable OPDSLF05 "ALL OPD VISITS-SELF/FAMILY AMT-DR 05";
label variable OPDMCR05 "ALL OPD VISITS-MEDICARE AMT -DR 05";
label variable OPDMCD05 "ALL OPD VISITS-MEDICAID AMT -DR 05";
label variable OPDPRV05 "ALL OPD VISITS-PRIV INS AMT-DR 05";
label variable OPDVA05 "ALL OPD VISITS-VA AMT-DR 05";
label variable OPDTRI05 "ALL OPD VISITS-TRICARE AMT-DR 05";
label variable OPDOFD05 "ALL OPD VISITS-OTHER FED AMT-DR 05";
label variable OPDSTL05 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 05";
label variable OPDWCP05 "ALL OPD VISITS-WORKERS COMP AMT-DR 05";
label variable OPDOPR05 "ALL OPD VISITS - OTH PRIVATE AMT-DR 05";
label variable OPDOPU05 "ALL OPD VISITS-OTH PUBLIC AMT-DR 05";
label variable OPDOSR05 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 05";
label variable OPDRV05 "# OUTPATIENT DEPT PHYSICIAN VISITS 05";
label variable OPVTCH05 "OPD PHYSICIAN VISIT CHARGES - FAC 05";
label variable OPVEXP05 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 05";
label variable OPVSLF05 "OPD DR VISITS-SELF/FAMILY AMT-FAC 05";
label variable OPVMCR05 "OPD DR VISITS-MEDICARE AMT-FAC 05";
label variable OPVMCD05 "OPD DR VISITS-MEDICAID AMT-FAC 05";
label variable OPVPRV05 "OPD DR VISITS-PRIV INS AMT-FAC 05";
label variable OPVVA05 "OPD DR VISITS-VA AMT-FAC 05";
label variable OPVTRI05 "OPD DR VISITS-TRICARE AMT-FAC 05";
label variable OPVOFD05 "OPD DR VISITS-OTHER FED AMT-FAC 05";
label variable OPVSTL05 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 05";
label variable OPVWCP05 "OPD DR VISITS-WORKERS COMP AMT-FAC 05";
label variable OPVOPR05 "OPD DR VISITS - OTH PRIVATE AMT-FAC 05";
label variable OPVOPU05 "OPD DR VISITS-OTH PUBLIC AMT-FAC 05";
label variable OPVOSR05 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 05";
label variable OPSEXP05 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 05";
label variable OPSTCH05 "OPD PHYSICIAN VISIT CHARGES - DR 05";
label variable OPSSLF05 "OPD DR VISITS-SELF/FAMILY AMT-DR 05";
label variable OPSMCR05 "OPD DR VISITS-MEDICARE AMT-DR 05";
label variable OPSMCD05 "OPD DR VISITS-MEDICAID AMT-DR 05";
label variable OPSPRV05 "OPD DR VISITS-PRIV INS AMT-DR 05";
label variable OPSVA05 "OPD DR VISITS-VA AMT-DR 05";
label variable OPSTRI05 "OPD DR VISITS-TRICARE AMT-DR 05";
label variable OPSOFD05 "OPD DR VISITS-OTHER FED AMT-DR 05";
label variable OPSSTL05 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 05";
label variable OPSWCP05 "OPD DR VISITS-WORKERS COMP AMT-DR 05";
label variable OPSOPR05 "OPD DR VISITS - OTH PRIVATE AMT-DR 05";
label variable OPSOPU05 "OPD DR VISITS-OTH PUBLIC AMT-DR 05";
label variable OPSOSR05 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 05";
label variable OPOTHV05 "# OUTPATIENT DEPT NON-DR VISITS 05";
label variable OPOTCH05 "OPD NON-PHYS VISIT CHARGES - FAC 05";
label variable OPOEXP05 "TOTAL OUTPATIENT NON-DR - FAC EXP 05";
label variable OPOSLF05 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 05";
label variable OPOMCR05 "OPD NON-DR VISITS-MEDICARE AMT-FAC 05";
label variable OPOMCD05 "OPD NON-DR VISITS-MEDICAID AMT-FAC 05";
label variable OPOPRV05 "OPD NON-DR VISITS-PRIV INS AMT-FAC 05";
label variable OPOVA05 "OPD NON-DR VISITS-VA AMT-FAC 05";
label variable OPOTRI05 "OPD NON-DR VISITS-TRICARE AMT-FAC 05";
label variable OPOOFD05 "OPD NON-DR VISITS-OTHER FED AMT-FAC 05";
label variable OPOSTL05 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 05";
label variable OPOWCP05 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 05";
label variable OPOOPR05 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 05";
label variable OPOOPU05 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 05";
label variable OPOOSR05 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 05";
label variable OPPEXP05 "TOTAL OUTPATIENT NON-DR - DR EXP 05";
label variable OPPTCH05 "OPD NON-PHYS VISIT CHARGES - DR 05";
label variable OPPSLF05 "OPD NON-DR VISITS-SELF/FAM AMT-DR 05";
label variable OPPMCR05 "OPD NON-DR VISITS-MEDICARE AMT-DR 05";
label variable OPPMCD05 "OPD NON-DR VISITS-MEDICAID AMT-DR 05";
label variable OPPPRV05 "OPD NON-DR VISITS-PRIV INS AMT-DR 05";
label variable OPPVA05 "OPD NON-DR VISITS-VA AMT-DR 05";
label variable OPPTRI05 "OPD NON-DR VISITS-TRICARE AMT-DR 05";
label variable OPPOFD05 "OPD NON-DR VISITS-OTHER FED AMT-DR 05";
label variable OPPSTL05 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 05";
label variable OPPWCP05 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 05";
label variable OPPOPR05 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 05";
label variable OPPOPU05 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 05";
label variable OPPOSR05 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 05";
label variable AMCHIR05 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2005";
label variable AMCTCH05 "CHIRO AMBULATORY VISIT CHARGES 05";
label variable AMCEXP05 "TOTL AMBULTRY (OB+OP) CHIRO EXP 05";
label variable AMCSLF05 "CHIRO AMB VISITS -SELF/FAMILY AMT 05";
label variable AMCMCR05 "CHIRO AMB VISITS -MEDICARE AMT 05";
label variable AMCMCD05 "CHIRO AMB VISITS -MEDICAID AMT 05";
label variable AMCPRV05 "CHIRO AMB VISITS -PRIVATE INS AMT 05";
label variable AMCVA05 "CHIRO AMB VISITS -VA AMT 05";
label variable AMCTRI05 "CHIRO AMB VISITS-TRICARE AMT 05";
label variable AMCOFD05 "CHIRO AMB VISITS -OTHER FEDERAL AMT 05";
label variable AMCSTL05 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 05";
label variable AMCWCP05 "CHIRO AMB VISITS-WORKERS COMP AMT 05";
label variable AMCOPR05 "CHIRO AMB VISITS - OTH PRIVATE AMT 05";
label variable AMCOPU05 "CHIRO AMB VISITS - OTH PUBLIC AMT 05";
label variable AMCOSR05 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 05";
label variable AMNURS05 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 05";
label variable AMNTCH05 "NRS/PRAC AMBULATORY VISIT CHARGES 05";
label variable AMNEXP05 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 05";
label variable AMNSLF05 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 05";
label variable AMNMCR05 "NRS/PRAC AMB VSTS -MEDICARE AMT 05";
label variable AMNMCD05 "NRS/PRAC AMB VSTS -MEDICAID AMT 05";
label variable AMNPRV05 "NRS/PRAC AMB VSTS -PRIV INS AMT 05";
label variable AMNVA05 "NRS/PRAC AMB VSTS-VA AMT 05";
label variable AMNTRI05 "NRS/PRAC AMB VSTS-TRICARE AMT 05";
label variable AMNOFD05 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 05";
label variable AMNSTL05 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 05";
label variable AMNWCP05 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 05";
label variable AMNOPR05 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 05";
label variable AMNOPU05 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 05";
label variable AMNOSR05 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 05";
label variable AMOPTO05 "# AMB OPTOMETRIST VSTS (OB+OP) 05";
label variable AMETCH05 "OPTOMETRIST AMBULATORY VISIT CHARGES 05";
label variable AMEEXP05 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 05";
label variable AMESLF05 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 05";
label variable AMEMCR05 "OPTMTRIST AMB VSTS -MEDICARE AMT 05";
label variable AMEMCD05 "OPTMTRIST AMB VSTS -MEDICAID AMT 05";
label variable AMEPRV05 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 05";
label variable AMEVA05 "OPTMTRIST AMB VSTS-VA AMT 05";
label variable AMETRI05 "OPTMTRIST AMB VSTS-TRICARE AMT 05";
label variable AMEOFD05 "OPTMTRIST AMB VSTS-OTHER FED AMT 05";
label variable AMESTL05 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 05";
label variable AMEWCP05 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 05";
label variable AMEOPR05 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 05";
label variable AMEOPU05 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 05";
label variable AMEOSR05 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 05";
label variable AMASST05 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2005";
label variable AMATCH05 "PHYS ASS T AMBULATORY VISIT CHARGES 05";
label variable AMAEXP05 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 05";
label variable AMASLF05 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 05";
label variable AMAMCR05 "PHYS ASS T AMB VSTS-MEDICARE AMT 05";
label variable AMAMCD05 "PHYS ASS T AMB VSTS-MEDICAID AMT 05";
label variable AMAPRV05 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 05";
label variable AMAVA05 "PHYS ASS T AMB VSTS-VA AMT 05";
label variable AMATRI05 "PHYS ASS T AMB VSTS-TRICARE AMT 05";
label variable AMAOFD05 "PHYS ASS T AMB VSTS -OTHER FED AMT 05";
label variable AMASTL05 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 05";
label variable AMAWCP05 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 05";
label variable AMAOPR05 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 05";
label variable AMAOPU05 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 05";
label variable AMAOSR05 "P A AMB VSTS- OTH UNCLASS SRCE AMT 05";
label variable AMTHER05 "# AMB PT/OT THRPY VISITS (OB+OP) 05";
label variable AMTTCH05 "PT/OC AMBULATORY VISIT CHARGES 05";
label variable AMTEXP05 "TOTL AMBULTRY (OB+OP) PT/OT EXP 05";
label variable AMTSLF05 "PT/OT AMB VISITS-SELF/FAMILY AMT 05";
label variable AMTMCR05 "PT/OT AMB VISITS-MEDICARE AMT 05";
label variable AMTMCD05 "PT/OT AMB VISITS-MEDICAID AMT 05";
label variable AMTPRV05 "PT/OT AMB VISITS-PRIVATE INS AMT 05";
label variable AMTVA05 "PT/OT AMB VISITS-VA AMT 05";
label variable AMTTRI05 "PT/OT AMB VISITS-TRICARE AMT 05";
label variable AMTOFD05 "PT/OT AMB VISITS -OTHER FED AMT 05";
label variable AMTSTL05 "PT/OT AMB VISITS-OTH ST/LOCL AMT 05";
label variable AMTWCP05 "PT/OT AMB VISITS-WORKERS COMP AMT 05";
label variable AMTOPR05 "PT/OT AMB VISITS - OTH PRIVATE AMT 05";
label variable AMTOPU05 "PT/OT AMB VISITS-OTH PUBLIC AMT 05";
label variable AMTOSR05 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 05";
label variable AMTOTC05 "# CALLS W/OFFICE & OUPAT DEPTS, 2005";
label variable AMDRC05 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2005";
label variable ERTOT05 "# EMERGENCY ROOM VISITS 05";
label variable ERFTCH05 "ER FACILITY VISIT CHARGES 05";
label variable ERFEXP05 "TOTAL ER FACILITY EXP 05";
label variable ERFSLF05 "ER-SELF/FAMILY AMT - FAC 05";
label variable ERFMCR05 "ER-MEDICARE AMT - FAC 05";
label variable ERFMCD05 "ER-MEDICAID AMT - FAC 05";
label variable ERFPRV05 "ER-PRIVATE INS AMT - FAC 05";
label variable ERFVA05 "ER-VA AMT - FAC 05";
label variable ERFTRI05 "ER-TRICARE AMT - FAC 05";
label variable ERFOFD05 "ER-OTHER FEDERAL AMT - FAC 05";
label variable ERFSTL05 "ER-OTH ST/LOCAL AMT - FAC 05";
label variable ERFWCP05 "ER-WORKERS COMP AMT - FAC 05";
label variable ERFOPR05 "ER-OTHER PRIVATE AMT - FAC 05";
label variable ERFOPU05 "ER-OTHER PUBLIC AMT - FAC 05";
label variable ERFOSR05 "ER-OTH UNCLASS SRCE AMT - FAC 05";
label variable ERDEXP05 "TOTAL EMERGENCY ROOM DR EXP 05";
label variable ERDTCH05 "ER DOCTOR VISIT CHARGES 05";
label variable ERDSLF05 "ER-SELF/FAMILY AMT - DR 05";
label variable ERDMCR05 "ER-MEDICARE AMT - DR 05";
label variable ERDMCD05 "ER-MEDICAID AMT - DR 05";
label variable ERDPRV05 "ER-PRIVATE INS AMT - DR 05";
label variable ERDVA05 "ER-VA AMT - DR 05";
label variable ERDTRI05 "ER-TRICARE AMT - DR 05";
label variable ERDOFD05 "ER-OTHER FED AMT - DR 05";
label variable ERDSTL05 "ER-OTH ST/LOCAL AMT - DR 05";
label variable ERDWCP05 "ER-WORKERS COMP AMT - DR 05";
label variable ERDOPR05 "ER - OTHER PRIVATE AMT - DR 05";
label variable ERDOPU05 "ER - OTHER PUBLIC AMT - DR 05";
label variable ERDOSR05 "ER-OTH UNCLASS SRCE AMT - DR 05";
label variable IPZERO05 "# ZERO-NIGHT HOSPITAL STAYS 05";
label variable ZIFTCH05 "ZERO-NITE IP STAY CHARGES - FAC 05";
label variable ZIFEXP05 "TOTAL ZERO-NITE STAYS FAC EXP 05";
label variable ZIFSLF05 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 05";
label variable ZIFMCR05 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 05";
label variable ZIFMCD05 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 05";
label variable ZIFPRV05 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 05";
label variable ZIFVA05 "ZERO-NITE IP STAZ-VA AMT-FAC 05";
label variable ZIFTRI05 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 05";
label variable ZIFOFD05 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 05";
label variable ZIFSTL05 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 05";
label variable ZIFWCP05 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 05";
label variable ZIFOPR05 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 05";
label variable ZIFOPU05 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 05";
label variable ZIFOSR05 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 05";
label variable ZIDEXP05 "TOTAL ZERO-NITE STAZ DR 05";
label variable ZIDTCH05 "ZERO-NITE IP STAY CHARGES - DR 05";
label variable ZIDSLF05 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 05";
label variable ZIDMCR05 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 05";
label variable ZIDMCD05 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 05";
label variable ZIDPRV05 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 05";
label variable ZIDVA05 "ZERO-NITE IP STAZ-VA AMT-DR 05";
label variable ZIDTRI05 "ZERO-NITE IP STAZ-TRICARE AMT-DR 05";
label variable ZIDOFD05 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 05";
label variable ZIDSTL05 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 05";
label variable ZIDWCP05 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 05";
label variable ZIDOPR05 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 05";
label variable ZIDOPU05 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 05";
label variable ZIDOSR05 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 05";
label variable IPDIS05 "# HOSPITAL DISCHARGES, 2005";
label variable IPFEXP05 "TOT HOSP IP FACILITY EXP-INC 0 NITES 05";
label variable IPFTCH05 "IP HOSP STAY CHARGES - FAC 05";
label variable IPFSLF05 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 05";
label variable IPFMCR05 "IP HOSP STAZ-MEDICARE AMT-FAC 05";
label variable IPFMCD05 "IP HOSP STAZ-MEDICAID AMT-FAC 05";
label variable IPFPRV05 "IP HOSP STAZ-PRIV INS AMT-FAC 05";
label variable IPFVA05 "IP HOSP STAZ-VA AMT-FAC 05";
label variable IPFTRI05 "IP HOSP STAZ-TRICARE AMT-FAC 05";
label variable IPFOFD05 "IP HOSP STAZ-OTHER FED AMT-FAC 05";
label variable IPFSTL05 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 05";
label variable IPFWCP05 "IP HOSP STAZ-WORKERS COMP AMT-FAC 05";
label variable IPFOPR05 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 05";
label variable IPFOPU05 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 05";
label variable IPFOSR05 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 05";
label variable IPDEXP05 "TOTL HOSP STAZ DR EXP 05";
label variable IPDTCH05 "IP HOSP STAY CHARGES - DR 05";
label variable IPDSLF05 "IP HOSP STAZ-SELF/FAMILY AMT-DR 05";
label variable IPDMCR05 "IP HOSP STAZ-MEDICARE AMT- DR 05";
label variable IPDMCD05 "IP HOSP STAZ-MEDICAID AMT-DR 05";
label variable IPDPRV05 "IP HOSP STAZ-PRIV INS AMT- DR 05";
label variable IPDVA05 "IP HOSP STAZ-VA AMT-DR 05";
label variable IPDTRI05 "IP HOSP STAZ-TRICARE AMT-DR 05";
label variable IPDOFD05 "IP HOSP STAZ-OTHER FED AMT-DR 05";
label variable IPDSTL05 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 05";
label variable IPDWCP05 "IP HOSP STAZ-WORKERS COMP AMT-DR 05";
label variable IPDOPR05 "IP HOSP STAZ - OTH PRIVATE AMT-DR 05";
label variable IPDOPU05 "IP HOSP STAZ - OTH PUBLIC AMT-DR 05";
label variable IPDOSR05 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 05";
label variable IPNGTD05 "# NIGHTS IN HOSP FOR DISCHARGES, 2005";
label variable DVTOT05 "# DENTAL CARE VISITS 05";
label variable DVTTCH05 "TOTAL DENTAL CARE VISIT CHARGES 05";
label variable DVTEXP05 "TOTAL DENTAL CARE EXP 05";
label variable DVTSLF05 "ALL DENTAL CARE -SELF/FAMILY AMT 05";
label variable DVTMCR05 "ALL DENTAL CARE -MEDICARE AMT 05";
label variable DVTMCD05 "ALL DENTAL CARE -MEDICAID AMT 05";
label variable DVTPRV05 "ALL DENTAL CARE -PRIVATE INS AMT 05";
label variable DVTVA05 "ALL DENTAL CARE -VA AMT 05";
label variable DVTTRI05 "ALL DENTAL CARE -TRICARE AMT 05";
label variable DVTOFD05 "ALL DENTAL CARE -OTHER FEDRL AMT 05";
label variable DVTSTL05 "ALL DENTAL CARE -OTH ST/LOCAL AMT 05";
label variable DVTWCP05 "ALL DENTAL CARE -WORKERS COMP AMT 05";
label variable DVTOPR05 "ALL DENTAL CARE - OTH PRIVATE AMT 05";
label variable DVTOPU05 "ALL DENTAL CARE - OTH PUBLIC AMT 05";
label variable DVTOSR05 "ALL DENT CARE-OT UNCLASS SRCE AMT 05";
label variable DVGEN05 "# GENERAL DENTIST VISITS 05";
label variable DVGTCH05 "GENERAL DENTAL CARE VISIT CHARGES 05";
label variable DVGEXP05 "TOTAL GENERAL DENTIST EXP 05";
label variable DVGSLF05 "GNRL DENTAL VISITS -SELF/FAM AMT 05";
label variable DVGMCR05 "GNRL DENTAL VISITS -MEDICARE AMT 05";
label variable DVGMCD05 "GNRL DENTAL VISITS -MEDICAID AMT 05";
label variable DVGPRV05 "GNRL DENTAL VISITS -PRIVATE INS AMT 05";
label variable DVGVA05 "GNRL DENTAL VISITS -VA AMT 05";
label variable DVGTRI05 "GNRL DENTAL VISITS-TRICARE AMT 05";
label variable DVGOFD05 "GNRL DENTAL VISITS- OTHER FED AMT 05";
label variable DVGSTL05 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 05";
label variable DVGWCP05 "GNRL DENTAL VISITS - WORKERS COMP AMT 05";
label variable DVGOPR05 "GNRL DENTAL VISITS - OTH PRIVATE AMT 05";
label variable DVGOPU05 "GNRL DENTAL VISITS - OTH PUBLIC AMT 05";
label variable DVGOSR05 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 05";
label variable DVORTH05 "# ORTHODONTIST VISITS 05";
label variable DVOTCH05 "ORTHODONTIST VISIT CHARGES 05";
label variable DVOEXP05 "TOTAL ORTHODONTIST EXP 05";
label variable DVOSLF05 "ORTHODONTIST VISITS -SELF/FAMILY AMT 05";
label variable DVOMCR05 "ORTHODONTIST VISITS -MEDICARE AMT 05";
label variable DVOMCD05 "ORTHODONTIST VISITS -MEDICAID AMT 05";
label variable DVOPRV05 "ORTHODONTIST VISITS -PRIVATE INS AMT 05";
label variable DVOVA05 "ORTHODONTIST VISITS-VA AMT 05";
label variable DVOTRI05 "ORTHODONTIST VISITS-TRICARE AMT 05";
label variable DVOOFD05 "ORTHODONTIST VISITS-OTHR FED AMT 05";
label variable DVOSTL05 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 05";
label variable DVOWCP05 "ORTHODONTIST VISITS-WORKERS COMP AMT 05";
label variable DVOOPR05 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 05";
label variable DVOOPU05 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 05";
label variable DVOOSR05 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 05";
label variable HHTOTD05 "# HOME HEALTH PROVIDER DAYS, 2005";
label variable HHAGD05 "# AGENCY HOME HEALTH PROVIDER DAYS 05";
label variable HHATCH05 "HOME HEALTH AGENCY VISIT CHARGES 05";
label variable HHAEXP05 "TOTAL HOME HEALTH AGENCY EXP 05";
label variable HHASLF05 "HOME HLTH AGENCY -SELF/FAMILY AMT 05";
label variable HHAMCR05 "HOME HLTH AGENCY -MEDICARE AMT 05";
label variable HHAMCD05 "HOME HLTH AGENCY -MEDICAID AMT 05";
label variable HHAPRV05 "HOME HLTH AGENCY -PRIVATE INS AMT 05";
label variable HHAVA05 "HOME HLTH AGENCY-VA AMT 05";
label variable HHATRI05 "HOME HLTH AGENCY-TRICARE AMT 05";
label variable HHAOFD05 "HOME HLTH AGENCY-OTHER FED AMT 05";
label variable HHASTL05 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 05";
label variable HHAWCP05 "HOME HLTH AGENCY- WORKERS COMP AMT 05";
label variable HHAOPR05 "HOME HLTH AGENCY - OTH PRIVATE AMT 05";
label variable HHAOPU05 "HOME HLTH AGENCY - OTH PUBLIC AMT 05";
label variable HHAOSR05 "H HLTH AGENCY - OT UNCLASS SRCE AMT 05";
label variable HHINDD05 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 05";
label variable HHNTCH05 "HOME HEALTH NON-AGENCY VISIT CHARGES 05";
label variable HHNEXP05 "TOTAL HOME HEALTH NON-AGNCY EXP 05";
label variable HHNSLF05 "HOME HLTH NON-AGNCY -SELF/FAM AMT 05";
label variable HHNMCR05 "HOME HLTH NON-AGNCY -MEDICARE AMT 05";
label variable HHNMCD05 "HOME HLTH NON-AGNCY -MEDICAID AMT 05";
label variable HHNPRV05 "HOME HLTH NON-AGNCY -PRIV INS AMT 05";
label variable HHNVA05 "HOME HLTH NON-AGNCY-VA AMT 05";
label variable HHNTRI05 "HOME HLTH NON-AGNCY-TRICARE AMT 05";
label variable HHNOFD05 "HOME HLTH NON-AGNCY-OTHR FED AMT 05";
label variable HHNSTL05 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 05";
label variable HHNWCP05 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 05";
label variable HHNOPR05 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 05";
label variable HHNOPU05 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 05";
label variable HHNOSR05 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 05";
label variable HHINFD05 "# INFORMAL HOME HEALTH PROVIDER DAYS 05";
label variable VISEXP05 "TOTAL GLASSES/CONTACT LENS EXP 05";
label variable VISTCH05 "GLASSES/CONTACT LENSES CHARGES 05";
label variable VISSLF05 "GLASSES/CNTCT LENSES -SELF/FAM AMT 05";
label variable VISMCR05 "GLASSES/CNTCT LENSES-MEDICARE AMT 05";
label variable VISMCD05 "GLASSES/CNTCT LENSES-MEDICAID AMT 05";
label variable VISPRV05 "GLASSES/CNTCT LENSES-PRIV INS AMT 05";
label variable VISVA05 "GLASSES/CNTCT LENSES-VA AMT 05";
label variable VISTRI05 "GLASSES/LENSES-TRICARE AMT 05";
label variable VISOFD05 "GLASSES/CNTCT LENSES-OTHR FED AMT 05";
label variable VISSTL05 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 05";
label variable VISWCP05 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 05";
label variable VISOPR05 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 05";
label variable VISOPU05 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 05";
label variable VISOSR05 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 05";
label variable OTHTCH05 "OTHER EQUP/SUPPLIES CHARGES 05";
label variable OTHEXP05 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 05";
label variable OTHSLF05 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 05";
label variable OTHMCR05 "OTHER EQUP/SUPPLIES-MEDICARE AMT 05";
label variable OTHMCD05 "OTHER EQUP/SUPPLIES-MEDICAID AMT 05";
label variable OTHPRV05 "OTHER EQUP/SUPPLIES-PRIV INS AMT 05";
label variable OTHVA05 "OTHER EQUP/SUPPLY-VA AMT 05";
label variable OTHTRI05 "OTHER EQUP/SUPPLY-TRICARE AMT 05";
label variable OTHOFD05 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 05";
label variable OTHSTL05 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 05";
label variable OTHWCP05 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 05";
label variable OTHOPR05 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 05";
label variable OTHOPU05 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 05";
label variable OTHOSR05 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 05";
label variable RXTOT05 "# PRESC MEDS INCL REFILLS 05";
label variable RXEXP05 "TOTAL RX-EXP 05";
label variable RXSLF05 "TOTAL RX-SELF/FAMILY AMT 05";
label variable RXMCR05 "TOTAL RX--MEDICARE AMT 05";
label variable RXMCD05 "TOTAL RX-MEDICAID AMT 05";
label variable RXPRV05 "TOTAL RX-PRIVATE INS AMT 05";
label variable RXVA05 "TOTAL RX-VA AMT 05";
label variable RXTRI05 "TOTAL RX-TRICARE AMT 05";
label variable RXOFD05 "TOTAL RX-OTHER FED AMT 05";
label variable RXSTL05 "TOTAL RX-OTHER ST/LOCAL AMT 05";
label variable RXWCP05 "TOTAL RX-WORKERS COMP AMT 05";
label variable RXOPR05 "TOTAL RX - OTH PRIVATE AMT 05";
label variable RXOPU05 "TOTAL RX - OTH PUBLIC AMT 05";
label variable RXOSR05 "TOT RX-OTH UNCLASS SRCE AMT 05";
label variable PERWT05F "FINAL PERSON WEIGHT, 2005";
label variable FAMWT05F "FINAL FAMILY WEIGHT, 2005";
label variable FAMWT05C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/05";
label variable SAQWT05F "FINAL SAQ-PAQ PERSON WEIGHT, 2005";
label variable DIABW05F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2005";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2005";


*DEFINE VALUE LABELS FOR REPORTS;
label define H970001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H970002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H970003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H970004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H970007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H970008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H970009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H970013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H970014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H970015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H970017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H970019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H970020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H970021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H970024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H970025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H970026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970029X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H970030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H970035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H970036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H970038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H970039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H970040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H970041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H970042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H970043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H970044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H970045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H970047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H970048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H970050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H970051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H970054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H970056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H970058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H970059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H970060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H970061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970063X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H970064X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970071X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970082X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970084X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970085X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970087X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970089X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970090X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2805 "$2805" ;

label define H970091X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970092X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970093X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970094X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970095X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970096X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970097X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970098X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970099X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970100X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970101X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         573 "$573" ;

label define H970102X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970103X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970104X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970105X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970106X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970107X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970108X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970109X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970110X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970111X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970112X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970113X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970114X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970115X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970116X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970117X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970118X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970119X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970120X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970121X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970122X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970123X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970124X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970125X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970126X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970127X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970128X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970129X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970130X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970131X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970132X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970133X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970134X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970135X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970136X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970137X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970138X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970139X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970140X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970141X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970143X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H970145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H970146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H970162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H970166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H970167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H970168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2004 "2004 YEAR"
         2005 "2005 YEAR" ;

label define H970169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2005 "2005 YEAR" ;

label define H970170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2005 "2005 YEAR"
         2006 "2006 YEAR" ;

label define H970171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H970172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H970173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970175X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H970176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H970179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H970182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H970183X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H970184X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H970185X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H970186X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970187X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H970189X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H970190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H970193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970195X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H970196X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H970197X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H970198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H970202X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970206X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H970207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970209X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H970210X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970211X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970212X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H970214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H970219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970230X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H970233X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H970234X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H970235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970237X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H970238X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H970239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H970242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970248X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970252X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H970253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H970254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H970256X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970257X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970258X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970259X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES" ;

label define H970260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H970261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970262X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H970264X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H970265X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H970266X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H970267X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H970268X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H970269X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970270X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H970271X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H970274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H970275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H970277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H970278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H970279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970280X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970281X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H970282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H970283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE BLOOD TEST" ;

label define H970285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE" ;

label define H970286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970296X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970297X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970298X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970299X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970300X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970301X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970302X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970303X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970304X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970305X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970306X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970307X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970308X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970309X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970310X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970311X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970312X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970313X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970314X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970315X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970316X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970317X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970318X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         132 "$132" ;

label define H970319X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970320X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970321X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970322X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970323X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970324X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970325X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970326X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         120 "$120" ;

label define H970327X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970329X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970330X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970331X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970332X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970333X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970334X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970335X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970336X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970337X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970338X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970339X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970340X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970341X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970342X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H970345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H970346X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H970347X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H970348X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H970349X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H970350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H970352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H970353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H970354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H970359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H970360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H970361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H970362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2005 "2005 YEAR" ;

label define H970363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2004 "2004 YEAR"
         2005 "2005 YEAR" ;

label define H970364X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2005 "2005 YEAR" ;

label define H970365X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2005 "2005 YEAR"
         2006 "2006 YEAR" ;

label define H970366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970367X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970368X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970369X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970370X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970371X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         100 "$100" ;

label define H970372X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970373X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970374X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970375X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970376X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970377X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970378X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970379X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970380X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970381X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970382X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970383X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970384X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970385X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970386X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970387X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970388X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970389X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970390X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970391X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970392X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970393X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970394X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970395X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970396X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970397X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970402X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970403X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970404X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H970405X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H970406X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H970407X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H970408X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H970409X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H970410X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970411X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H970412X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H970413X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H970414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H970415X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H970416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H970417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H970418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H970422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H970423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H970424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H970425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H970426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H970427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H970428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE"
         2 "2 IS DRIVEN"
         3 "3 TAXI, BUS, TRAIN, OTHER PUBLIC TRANSPO"
         4 "4 WALKS" ;

label define H970429X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970430X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H970431X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970432X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970433X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970434X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970435X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H970436X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970437X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970438X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970439X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970440X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970441X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970442X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970443X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970444X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970445X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970446X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970447X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970448X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970449X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970450X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970451X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970452X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970453X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970454X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970455X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         728 "$728" ;

label define H970456X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970457X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970458X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970459X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970460X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970461X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970462X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970463X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970464X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         600 "$600" ;

label define H970465X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970466X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970467X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970468X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970469X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970470X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970471X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970472X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970473X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970474X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H970475X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H970476X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN/CUBAN AMERICAN"
         3 "3 DOMINICAN"
         4 "4 MEXICAN/MEXICAN AMERICAN"
         5 "5 CENTRAL OR SOUTH AMERICAN"
         6 "6 NON-HISPANIC"
         91 "91 OTHER LATIN AMERICAN"
         92 "92 OTHER HISPANIC/LATINO" ;

label define H970477X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H970478X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H970479X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970480X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970481X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970492X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970493X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970494X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970495X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970496X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970497X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970498X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970499X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970500X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970501X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970502X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970503X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970504X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970551X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970552X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970553X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970554X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H970555X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H970556X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H970557X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $72.12"
         -9 "-9 NOT ASCERTAINED" ;

label define H970558X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= 72.12"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H970559X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $72.12"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H970560X
         0 "0 NO"
         1 "1 YES" ;

label define H970561X
         0 "0 NO"
         1 "1 YES" ;

label define H970562X
         0 "0 NO"
         1 "1 YES" ;

label define H970563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970566X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970567X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970568X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970569X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970570X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970571X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970572X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970573X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H970574X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H970575X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H970576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970582X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970583X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970585X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970586X
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/2005"
         2 "2 NOT IN-SCOPE ON 12/31/2005" ;

label define H970587X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/05"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H970588X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/05"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H970589X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/05"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H970590X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/05"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H970591X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2005"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2005" ;

label define H970592X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H970593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970594X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970595X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970596X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970597X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970598X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970599X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970600X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970601X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970602X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970603X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970604X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970605X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970606X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H970607X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970608X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H970609X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970610X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970611X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970612X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970613X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970614X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970615X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970616X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970617X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970618X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970619X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970620X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970621X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970622X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970623X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970624X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970625X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970626X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970627X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970628X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970629X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970630X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970631X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970632X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970633X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970634X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970635X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970636X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970637X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970638X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970639X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970640X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H970641X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970642X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970643X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H970644X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H970645X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H970646X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970647X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970648X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970649X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H970650X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H970651X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H970652X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970653X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ANOTHER LANGUAGE" ;

label define H970654X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970655X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970656X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H970657X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H970658X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970659X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970660X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H970661X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H970662X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970663X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H970664X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H970665X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H970666X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H970667X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H970668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970669X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970670X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970671X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970672X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970673X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970674X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970675X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970676X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970677X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970678X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970680X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970681X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970682X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970683X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970684X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970685X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970686X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970688X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970690X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970691X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970692X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970693X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970694X
         1 "1 YES"
         2 "2 NO" ;

label define H970695X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970696X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970697X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H970698X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H970699X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H970700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970701X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970704X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970705X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970706X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970707X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970708X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H970709X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H970710X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H970711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970712X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970725X
         1 "1 YES"
         2 "2 NO" ;

label define H970726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970728X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970741X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970742X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970743X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970744X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H970745X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970746X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H970747X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H970748X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970749X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H970750X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H970751X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H970752X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970753X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H970754X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970755X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970756X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H970757X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H970758X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970759X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H970760X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H970761X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H970762X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H970763X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970764X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970765X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970766X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970767X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H970768X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H970769X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H970770X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H970771X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H970772X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H970773X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H970774X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970775X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970776X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H970777X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H970778X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970779X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970780X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$72.12"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H970781X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$72.12"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H970782X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$72.12"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H970783X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970784X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970785X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970786X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970787X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970788X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H970789X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970790X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970791X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970792X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970793X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970794X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H970795X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970796X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H970797X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H970798X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H970799X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970800X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970801X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970802X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970803X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970804X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970805X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970806X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970807X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970808X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970809X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970810X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970811X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970812X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970813X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970814X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970815X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970816X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970817X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970818X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970819X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970820X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970821X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970822X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970823X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970824X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2805 "$2805" ;

label define H970825X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970826X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970827X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970828X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970829X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970830X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970831X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970832X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970833X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970834X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970835X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970836X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970837X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970838X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970839X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970840X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970841X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970842X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970843X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970844X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970845X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970846X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970847X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970848X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970849X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         573 "$573" ;

label define H970850X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970851X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970852X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970853X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970854X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970855X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970856X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970857X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970858X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970859X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970860X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970861X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970862X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970863X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970864X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970865X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970866X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970867X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970868X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970869X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970870X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970871X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970872X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970873X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970874X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970875X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970876X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970877X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970878X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970879X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970880X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970881X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970882X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970883X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970884X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970885X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970886X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970887X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970888X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970889X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970890X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970891X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970892X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970893X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970894X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970895X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970896X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970897X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970898X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970899X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970900X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970901X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970902X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970903X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970904X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970905X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970906X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970907X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970908X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970909X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970910X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970911X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970912X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970913X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970914X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970915X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970916X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970917X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970918X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970919X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H970920X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H970921X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1996"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H970922X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970923X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970924X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970925X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970926X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970927X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970928X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970929X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970930X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970931X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H970932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970933X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970935X
         1 "1 YES"
         2 "2 NO" ;

label define H970936X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970937X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970938X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970939X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970940X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970941X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970942X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970945X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970946X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970947X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970948X
         1 "1 YES"
         2 "2 NO" ;

label define H970949X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970950X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970951X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970952X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970953X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970954X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970955X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970956X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970957X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H970958X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970959X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970960X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970961X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         17 "$17" ;

label define H970962X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970963X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970964X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970965X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970966X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970967X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970968X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970969X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970970X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970971X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970972X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970973X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970974X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970975X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970976X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970977X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970978X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970979X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970980X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970981X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970982X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970983X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970984X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970985X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970986X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970987X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970988X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970989X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970990X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970991X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970992X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970993X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970994X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970995X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970996X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970997X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970998X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H970999X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971000X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971001X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971002X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971003X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971004X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971005X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         17 "$17" ;

label define H971006X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971007X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971008X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         45 "$45" ;

label define H971009X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971010X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971011X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971012X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971013X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971014X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971015X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971016X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971017X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971018X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971019X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971020X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971021X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971022X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971023X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971024X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971025X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971026X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971027X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971028X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971029X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971030X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971031X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971032X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971033X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971034X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971035X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971036X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971037X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971038X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971039X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971040X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971041X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971042X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971043X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971044X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971048X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971049X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H971050X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971051X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971052X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971056X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971057X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971058X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971059X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971060X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971062X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971063X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971064X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971070X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971071X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971072X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971073X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971074X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971075X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971076X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971077X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971078X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971079X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971080X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971081X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971082X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971083X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971084X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971085X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971087X
         10 "10 PANEL 10"
         9 "9 PANEL 9" ;

label define H971088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H971089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971090X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971091X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971093X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971094X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H971096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H971097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H971098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H971099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H971100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H971101X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971102X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971103X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971104X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971105X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971106X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971107X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971108X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971109X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971110X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971111X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971112X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971113X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971114X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971115X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971116X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971117X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971118X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971119X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971120X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971121X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971122X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971123X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971124X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971125X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H971126X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971127X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971128X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H971129X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H971130X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H971131X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H971132X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971133X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H971134X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971135X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971136X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H971137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H971139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H971140X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971141X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971142X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA"
         5 "5 TRICARE/CHAMPVA"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H971144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA"
         5 "5 TRICARE/CHAMPVA"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H971145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA"
         5 "5 TRICARE/CHAMPVA"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H971146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971149X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H971150X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H971151X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H971152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H971154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H971155X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971156X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971157X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971158X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971159X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971160X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971161X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971162X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971163X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971164X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971165X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971166X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971167X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971168X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971169X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971170X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971171X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971172X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971173X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971174X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971175X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971176X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971177X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971178X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971179X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971180X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971181X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971182X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971183X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971184X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971185X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971186X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971187X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971188X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971189X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971190X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971191X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H971192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971194X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST-NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H971195X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H971196X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H971197X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971199X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971200X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971201X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971202X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971203X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971204X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971205X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971206X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971207X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971208X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971209X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971210X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971211X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971212X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971213X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971214X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971215X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971216X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971217X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971218X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971219X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971220X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971221X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971222X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971223X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971224X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971225X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971226X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971227X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971228X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971229X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971230X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971231X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971232X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971233X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971234X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971235X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971236X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971237X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971238X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971239X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971240X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971241X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971242X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971243X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H971244X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H971245X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H971246X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H971247X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H971248X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971249X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971250X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971251X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971252X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971253X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971254X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971255X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971256X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971257X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971258X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971259X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971260X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H971261X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H971262X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H971263X
         1 "1 YES"
         2 "2 NO" ;

label define H971264X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H971265X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H971266X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H971267X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H971268X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H971269X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H971270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H971271X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H971272X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H971273X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H971274X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971275X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971276X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971277X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971278X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971279X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971280X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971281X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971282X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971283X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971284X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971285X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971286X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H971287X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971288X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971289X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971290X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971291X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971292X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971293X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971294X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971295X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971296X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H971297X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H971298X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK-NO OTH RACE/NOT HISPANIC"
         3 "3 PERSON IS ASIAN-NO OTH RACE/NOT HISPANIC"
         4 "4 OTHER RACE/NOT HISPANIC" ;

label define H971299X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H971300X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE - NO OTH RAC"
         4 "4 ASIAN - NO OTHER RACE REPORTED"
         5 "5 NATIVE HAWAIIAN/PACIFIC ISLANDER-NO OTHR"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H971301X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H971302X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H971303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971305X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971307X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971308X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H971309X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H971310X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H971311X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H971312X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H971313X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H971314X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H971315X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H971316X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H971317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H971318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971319X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971320X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971321X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H971322X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H971323X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H971324X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H971325X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H971326X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H971327X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H971328X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H971329X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H971330X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H971331X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H971332X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H971333X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H971334X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H971335X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H971336X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H971337X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H971338X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H971339X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971340X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971341X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971342X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971343X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971344X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971345X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971346X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971347X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971348X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971349X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971350X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971351X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971352X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971354X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H971355X
         0 "0 NOT ELIGIBLE"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H971356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H971357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H971360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H971364X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971365X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971367X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971368X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971369X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H971370X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H971371X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H971372X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H971373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971374X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971375X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971378X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H971379X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H971380X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H971381X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H971382X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H971383X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H971384X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H971385X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H971386X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H971387X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971388X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H971389X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971390X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABILITY"
         2 "2 SOME OTHER REASON" ;

label define H971391X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H971392X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971393X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H971394X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H971395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H971396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971412X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H971413X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H971414X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H971415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H971416X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H971417X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H971418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H971419X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H971420X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H971421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H971422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H971423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H971426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H971427X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971428X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971429X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971430X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971431X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971432X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG TERM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H971433X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H971434X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H971435X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H971436X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971437X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971438X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971439X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971440X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971441X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SORE THROAT"
         2 "2 OTHER SYMPTOMS" ;

label define H971442X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971443X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H971444X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971445X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971446X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971447X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971448X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971449X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971450X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971451X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971452X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971453X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971454X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971455X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971456X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971457X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971458X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971459X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971460X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H971461X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971462X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971463X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971464X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971465X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971466X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971467X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971468X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE - CHAMPVA NOT ASCERTAINED"
         1 "1 COV BY TRICARE CHAMPVA"
         2 "2 COV BY TRICARE - NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE" ;

label define H971469X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE - CHAMPVA NOT ASCERTAINED"
         1 "1 COV BY TRICARE CHAMPVA"
         2 "2 COV BY TRICARE - NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE" ;

label define H971470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971471X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971472X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971473X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971474X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971475X
         1 "1 YES"
         2 "2 NO" ;

label define H971476X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H971477X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H971478X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H971479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971480X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971481X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971483X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI FOR LIFE NOT ASCERTAINED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICARE - NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE" ;

label define H971484X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI FOR LIFE NOT ASCERTAINED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICARE - NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE" ;

label define H971485X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI FOR LIFE NOT ASCERTAINED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICARE - NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE" ;

label define H971486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971490X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H971491X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H971492X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H971493X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H971494X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H971495X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H971496X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H971497X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H971498X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971499X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD- RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H971500X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971501X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971502X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H971503X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971504X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H971505X
         1 "1 YES"
         2 "2 NO" ;

label define H971506X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971507X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971508X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971509X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971510X
         1 "1 ORIGINAL RESPONSE USED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H971511X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971512X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971513X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H971514X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971515X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971516X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971517X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971518X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971519X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971520X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971521X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971522X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971523X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971524X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971525X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971526X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971527X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         146 "$146" ;

label define H971528X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971529X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H971530X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971531X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971532X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971533X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971534X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971535X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971536X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971537X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971538X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971539X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971540X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971541X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971542X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971543X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971544X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971545X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H971546X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H971547X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971548X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H971549X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H971550X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H971551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H971552X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H971553X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H971554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H971555X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H971556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H971557X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H971558X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H971559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H971560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971562X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971566X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H971567X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H971568X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971569X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971570X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971571X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H971572X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971573X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H971574X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H971575X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H971576X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H971577X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H971578X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEMS"
         91 "91 SOME OTHER REASON" ;

label define H971579X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 INSURANCE-RELATED REASONS"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H971580X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971581X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971582X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971583X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971584X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         702 "$702" ;

label define H971585X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         233 "$233" ;

label define H971586X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         226 "$226" ;

label define H971587X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971588X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971589X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971590X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971591X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971592X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971593X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         15 "$15" ;

label define H971594X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971595X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971596X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971597X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971598X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971599X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         737 "$737" ;

label define H971600X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971601X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971602X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971603X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971604X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971605X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971606X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H971607X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H970001X;
label value ACTDTY42 H970002X;
label value ACTDTY53 H970003X;
label value ACTLIM31 H970004X;
label value ACTLIM53 H970005X;
label value ADAPPT42 H970006X;
label value ADCAPE42 H970007X;
label value ADCLIM42 H970008X;
label value ADCMPD42 H970009X;
label value ADCMPM42 H970010X;
label value ADCMPY42 H970011X;
label value ADDAYA42 H970012X;
label value ADDOWN42 H970013X;
label value ADDPRS42 H970014X;
label value ADDRBP42 H970015X;
label value ADEFRT42 H970016X;
label value ADEXPL42 H970017X;
label value ADGENH42 H970018X;
label value ADHECR42 H970019X;
label value ADHOPE42 H970020X;
label value ADILCR42 H970021X;
label value ADILWW42 H970022X;
label value ADINSA42 H970023X;
label value ADINSB42 H970024X;
label value ADINTR42 H970025X;
label value ADL3MO31 H970026X;
label value ADL3MO42 H970027X;
label value ADL3MO53 H970028X;
label value ADLANG42 H970029X;
label value ADLHLP31 H970030X;
label value ADLHLP42 H970031X;
label value ADLHLP53 H970032X;
label value ADLIST42 H970033X;
label value ADMALS42 H970034X;
label value ADMWLM42 H970035X;
label value ADNDCR42 H970036X;
label value ADNECP42 H970037X;
label value ADNERV42 H970038X;
label value ADNRGY42 H970039X;
label value ADNSMK42 H970040X;
label value ADOVER42 H970041X;
label value ADPAIN42 H970042X;
label value ADPALS42 H970043X;
label value ADPRRE42 H970044X;
label value ADPRTM42 H970045X;
label value ADPRX42 H970046X;
label value ADPWLM42 H970047X;
label value ADRESP42 H970048X;
label value ADREST42 H970049X;
label value ADRISK42 H970050X;
label value ADRTCR42 H970051X;
label value ADRTWW42 H970052X;
label value ADSAD42 H970053X;
label value ADSMOK42 H970054X;
label value ADSOCA42 H970055X;
label value ADSPEC42 H970056X;
label value ADUPRO42 H970057X;
label value ADWRTH42 H970058X;
label value AFDC05 H970059X;
label value AFTHOU42 H970060X;
label value AIDHLP31 H970061X;
label value AIDHLP53 H970062X;
label value ALIIMP05 H970063X;
label value ALIMP05X H970064X;
label value AMAEXP05 H970065X;
label value AMAMCD05 H970066X;
label value AMAMCR05 H970067X;
label value AMAOFD05 H970068X;
label value AMAOPR05 H970069X;
label value AMAOPU05 H970070X;
label value AMAOSR05 H970071X;
label value AMAPRV05 H970072X;
label value AMASLF05 H970073X;
label value AMASST05 H970074X;
label value AMASTL05 H970075X;
label value AMATCH05 H970076X;
label value AMATRI05 H970077X;
label value AMAVA05 H970078X;
label value AMAWCP05 H970079X;
label value AMCEXP05 H970080X;
label value AMCHIR05 H970081X;
label value AMCMCD05 H970082X;
label value AMCMCR05 H970083X;
label value AMCOFD05 H970084X;
label value AMCOPR05 H970085X;
label value AMCOPU05 H970086X;
label value AMCOSR05 H970087X;
label value AMCPRV05 H970088X;
label value AMCSLF05 H970089X;
label value AMCSTL05 H970090X;
label value AMCTCH05 H970091X;
label value AMCTRI05 H970092X;
label value AMCVA05 H970093X;
label value AMCWCP05 H970094X;
label value AMDRC05 H970095X;
label value AMEEXP05 H970096X;
label value AMEMCD05 H970097X;
label value AMEMCR05 H970098X;
label value AMEOFD05 H970099X;
label value AMEOPR05 H970100X;
label value AMEOPU05 H970101X;
label value AMEOSR05 H970102X;
label value AMEPRV05 H970103X;
label value AMESLF05 H970104X;
label value AMESTL05 H970105X;
label value AMETCH05 H970106X;
label value AMETRI05 H970107X;
label value AMEVA05 H970108X;
label value AMEWCP05 H970109X;
label value AMNEXP05 H970110X;
label value AMNMCD05 H970111X;
label value AMNMCR05 H970112X;
label value AMNOFD05 H970113X;
label value AMNOPR05 H970114X;
label value AMNOPU05 H970115X;
label value AMNOSR05 H970116X;
label value AMNPRV05 H970117X;
label value AMNSLF05 H970118X;
label value AMNSTL05 H970119X;
label value AMNTCH05 H970120X;
label value AMNTRI05 H970121X;
label value AMNURS05 H970122X;
label value AMNVA05 H970123X;
label value AMNWCP05 H970124X;
label value AMOPTO05 H970125X;
label value AMTEXP05 H970126X;
label value AMTHER05 H970127X;
label value AMTMCD05 H970128X;
label value AMTMCR05 H970129X;
label value AMTOFD05 H970130X;
label value AMTOPR05 H970131X;
label value AMTOPU05 H970132X;
label value AMTOSR05 H970133X;
label value AMTOTC05 H970134X;
label value AMTPRV05 H970135X;
label value AMTSLF05 H970136X;
label value AMTSTL05 H970137X;
label value AMTTCH05 H970138X;
label value AMTTRI05 H970139X;
label value AMTVA05 H970140X;
label value AMTWCP05 H970141X;
label value ANGIDX53 H970142X;
label value ANYLIM05 H970143X;
label value APRDLM42 H970144X;
label value APRDLT42 H970145X;
label value APRTRM42 H970146X;
label value APRTRT42 H970147X;
label value ARTHDX53 H970148X;
label value ARTHTX53 H970149X;
label value ASACUT53 H970150X;
label value ASATAK53 H970151X;
label value ASDALY53 H970152X;
label value ASEVFL53 H970153X;
label value ASIANP42 H970154X;
label value ASMRCN53 H970155X;
label value ASPKFL53 H970156X;
label value ASPREV53 H970157X;
label value ASPRIN53 H970158X;
label value ASSTIL53 H970159X;
label value ASTHDX53 H970160X;
label value ASWNFL53 H970161X;
label value BEGRFD31 H970162X;
label value BEGRFD42 H970163X;
label value BEGRFD53 H970164X;
label value BEGRFM31 H970165X;
label value BEGRFM42 H970166X;
label value BEGRFM53 H970167X;
label value BEGRFY31 H970168X;
label value BEGRFY42 H970169X;
label value BEGRFY53 H970170X;
label value BENDIF31 H970171X;
label value BENDIF53 H970172X;
label value BLCKPR42 H970173X;
label value BLIND42 H970174X;
label value BMINDX53 H970175X;
label value BOOST42 H970176X;
label value BOWEL53 H970177X;
label value BPCHEK53 H970178X;
label value BPMLDX53 H970179X;
label value BPMONT53 H970180X;
label value BRSTEX53 H970181X;
label value BSNTY31 H970182X;
label value BSNTY42 H970183X;
label value BSNTY53 H970184X;
label value BUSIMP05 H970185X;
label value CARECO42 H970186X;
label value CASHP05X H970187X;
label value CHAPPT42 H970188X;
label value CHBMIX42 H970189X;
label value CHCOUN42 H970190X;
label value CHDDX53 H970191X;
label value CHECK53 H970192X;
label value CHEMPB42 H970193X;
label value CHEXPL42 H970194X;
label value CHGJ3142 H970195X;
label value CHGJ4253 H970196X;
label value CHHECR42 H970197X;
label value CHILCR42 H970198X;
label value CHILWW42 H970199X;
label value CHLAGE53 H970200X;
label value CHLCHK53 H970201X;
label value CHLDP05X H970202X;
label value CHLICO42 H970203X;
label value CHLIHB42 H970204X;
label value CHLIMI42 H970205X;
label value CHLIMP05 H970206X;
label value CHLIST42 H970207X;
label value CHNDCR42 H970208X;
label value CHNECP42 H970209X;
label value CHOIC31 H970210X;
label value CHOIC42 H970211X;
label value CHOIC53 H970212X;
label value CHOLCK53 H970213X;
label value CHOLDX53 H970214X;
label value CHPMCN42 H970215X;
label value CHPMED42 H970216X;
label value CHPMHB42 H970217X;
label value CHPRRE42 H970218X;
label value CHPRTM42 H970219X;
label value CHRESP42 H970220X;
label value CHRTCR42 H970221X;
label value CHRTWW42 H970222X;
label value CHSERV42 H970223X;
label value CHSPEC42 H970224X;
label value CHSRCN42 H970225X;
label value CHSRHB42 H970226X;
label value CHTHCO42 H970227X;
label value CHTHER42 H970228X;
label value CHTHHB42 H970229X;
label value CLINIC42 H970230X;
label value CLMDEP05 H970231X;
label value CLMHIP05 H970232X;
label value COGLIM31 H970233X;
label value COGLIM53 H970234X;
label value COVRMM H970235X;
label value COVRYY H970236X;
label value CSHCN42 H970237X;
label value CSHIMP05 H970238X;
label value CSTSVM42 H970239X;
label value CSTSVT42 H970240X;
label value DADPRO42 H970241X;
label value DDBDYS31 H970242X;
label value DDBDYS42 H970243X;
label value DDBDYS53 H970244X;
label value DDNSCL31 H970245X;
label value DDNSCL42 H970246X;
label value DDNSCL53 H970247X;
label value DDNWRK31 H970248X;
label value DDNWRK42 H970249X;
label value DDNWRK53 H970250X;
label value DEAF42 H970251X;
label value DECIDE42 H970252X;
label value DEDUCT05 H970253X;
label value DENTAL42 H970254X;
label value DENTCK53 H970255X;
label value DENTIN31 H970256X;
label value DENTIN42 H970257X;
label value DENTIN53 H970258X;
label value DEPDNT05 H970259X;
label value DFTOUS42 H970260X;
label value DIABDX53 H970261X;
label value DIFFPL42 H970262X;
label value DIFFWG31 H970263X;
label value DIFFWG42 H970264X;
label value DIFFWG53 H970265X;
label value DISVW31X H970266X;
label value DISVW42X H970267X;
label value DISVW53X H970268X;
label value DIVDP05X H970269X;
label value DIVIMP05 H970270X;
label value DKWHRU42 H970271X;
label value DNDLAY42 H970272X;
label value DNDLPR42 H970273X;
label value DNDLRS42 H970274X;
label value DNUNAB42 H970275X;
label value DNUNPR42 H970276X;
label value DNUNRS42 H970277X;
label value DOBMM H970278X;
label value DOBYY H970279X;
label value DOCELS42 H970280X;
label value DPINRU05 H970281X;
label value DPOTSD05 H970282X;
label value DRTHRT53 H970283X;
label value DSA1C53 H970284X;
label value DSCKFT53 H970285X;
label value DSDIA53 H970286X;
label value DSDIET53 H970287X;
label value DSEB0453 H970288X;
label value DSEY0453 H970289X;
label value DSEY0553 H970290X;
label value DSEY0653 H970291X;
label value DSEYNV53 H970292X;
label value DSEYPR53 H970293X;
label value DSINSU53 H970294X;
label value DSKIDN53 H970295X;
label value DSMED53 H970296X;
label value DSPRX53 H970297X;
label value DVGEN05 H970298X;
label value DVGEXP05 H970299X;
label value DVGMCD05 H970300X;
label value DVGMCR05 H970301X;
label value DVGOFD05 H970302X;
label value DVGOPR05 H970303X;
label value DVGOPU05 H970304X;
label value DVGOSR05 H970305X;
label value DVGPRV05 H970306X;
label value DVGSLF05 H970307X;
label value DVGSTL05 H970308X;
label value DVGTCH05 H970309X;
label value DVGTRI05 H970310X;
label value DVGVA05 H970311X;
label value DVGWCP05 H970312X;
label value DVOEXP05 H970313X;
label value DVOMCD05 H970314X;
label value DVOMCR05 H970315X;
label value DVOOFD05 H970316X;
label value DVOOPR05 H970317X;
label value DVOOPU05 H970318X;
label value DVOOSR05 H970319X;
label value DVOPRV05 H970320X;
label value DVORTH05 H970321X;
label value DVOSLF05 H970322X;
label value DVOSTL05 H970323X;
label value DVOTCH05 H970324X;
label value DVOTRI05 H970325X;
label value DVOVA05 H970326X;
label value DVOWCP05 H970327X;
label value DVTEXP05 H970328X;
label value DVTMCD05 H970329X;
label value DVTMCR05 H970330X;
label value DVTOFD05 H970331X;
label value DVTOPR05 H970332X;
label value DVTOPU05 H970333X;
label value DVTOSR05 H970334X;
label value DVTOT05 H970335X;
label value DVTPRV05 H970336X;
label value DVTSLF05 H970337X;
label value DVTSTL05 H970338X;
label value DVTTCH05 H970339X;
label value DVTTRI05 H970340X;
label value DVTVA05 H970341X;
label value DVTWCP05 H970342X;
label value EATHLT42 H970343X;
label value EDUCYR H970344X;
label value EICRDT05 H970345X;
label value ELGRND05 H970346X;
label value ELGRND31 H970347X;
label value ELGRND42 H970348X;
label value ELGRND53 H970349X;
label value EMPHDX53 H970350X;
label value EMPST31 H970351X;
label value EMPST42 H970352X;
label value EMPST53 H970353X;
label value ENDRFD05 H970354X;
label value ENDRFD31 H970355X;
label value ENDRFD42 H970356X;
label value ENDRFD53 H970357X;
label value ENDRFM05 H970358X;
label value ENDRFM31 H970359X;
label value ENDRFM42 H970360X;
label value ENDRFM53 H970361X;
label value ENDRFY05 H970362X;
label value ENDRFY31 H970363X;
label value ENDRFY42 H970364X;
label value ENDRFY53 H970365X;
label value ENGHME42 H970366X;
label value ENGSPK42 H970367X;
label value ERDEXP05 H970368X;
label value ERDMCD05 H970369X;
label value ERDMCR05 H970370X;
label value ERDOFD05 H970371X;
label value ERDOPR05 H970372X;
label value ERDOPU05 H970373X;
label value ERDOSR05 H970374X;
label value ERDPRV05 H970375X;
label value ERDSLF05 H970376X;
label value ERDSTL05 H970377X;
label value ERDTCH05 H970378X;
label value ERDTRI05 H970379X;
label value ERDVA05 H970380X;
label value ERDWCP05 H970381X;
label value ERFEXP05 H970382X;
label value ERFMCD05 H970383X;
label value ERFMCR05 H970384X;
label value ERFOFD05 H970385X;
label value ERFOPR05 H970386X;
label value ERFOPU05 H970387X;
label value ERFOSR05 H970388X;
label value ERFPRV05 H970389X;
label value ERFSLF05 H970390X;
label value ERFSTL05 H970391X;
label value ERFTCH05 H970392X;
label value ERFTRI05 H970393X;
label value ERFVA05 H970394X;
label value ERFWCP05 H970395X;
label value ERTOT05 H970396X;
label value EVRETIRE H970397X;
label value EVRUNAT H970398X;
label value EVRUNINS H970399X;
label value EVRWRK H970400X;
label value EXPLOP42 H970401X;
label value EXRCIS53 H970402X;
label value FACLPR42 H970403X;
label value FAMRFPYR H970404X;
label value FAMSZE05 H970405X;
label value FAMSZE31 H970406X;
label value FAMSZE42 H970407X;
label value FAMSZE53 H970408X;
label value FCRP1231 H970409X;
label value FILEDR05 H970410X;
label value FILER05 H970411X;
label value FLSHOT53 H970412X;
label value FLSTAT05 H970413X;
label value FLUSHT53 H970414X;
label value FMRS1231 H970415X;
label value FNGRDF31 H970416X;
label value FNGRDF53 H970417X;
label value FOODMN05 H970418X;
label value FOODST05 H970419X;
label value FOODVL05 H970420X;
label value FTSTU05X H970421X;
label value FTSTU31X H970422X;
label value FTSTU42X H970423X;
label value FTSTU53X H970424X;
label value GDCPBM42 H970425X;
label value GDCPBT42 H970426X;
label value GENDRP42 H970427X;
label value GOTOUS42 H970428X;
label value HAVEUS42 H970429X;
label value HAVFUN42 H970430X;
label value HEALTH42 H970431X;
label value HEARAD42 H970432X;
label value HEARDI42 H970433X;
label value HEARMO42 H970434X;
label value HEARNG42 H970435X;
label value HEARSM42 H970436X;
label value HELD31X H970437X;
label value HELD42X H970438X;
label value HELD53X H970439X;
label value HELMET42 H970440X;
label value HHAEXP05 H970441X;
label value HHAGD05 H970442X;
label value HHAMCD05 H970443X;
label value HHAMCR05 H970444X;
label value HHAOFD05 H970445X;
label value HHAOPR05 H970446X;
label value HHAOPU05 H970447X;
label value HHAOSR05 H970448X;
label value HHAPRV05 H970449X;
label value HHASLF05 H970450X;
label value HHASTL05 H970451X;
label value HHATCH05 H970452X;
label value HHATRI05 H970453X;
label value HHAVA05 H970454X;
label value HHAWCP05 H970455X;
label value HHINDD05 H970456X;
label value HHINFD05 H970457X;
label value HHNEXP05 H970458X;
label value HHNMCD05 H970459X;
label value HHNMCR05 H970460X;
label value HHNOFD05 H970461X;
label value HHNOPR05 H970462X;
label value HHNOPU05 H970463X;
label value HHNOSR05 H970464X;
label value HHNPRV05 H970465X;
label value HHNSLF05 H970466X;
label value HHNSTL05 H970467X;
label value HHNTCH05 H970468X;
label value HHNTRI05 H970469X;
label value HHNVA05 H970470X;
label value HHNWCP05 H970471X;
label value HHTOTD05 H970472X;
label value HIBPDX53 H970473X;
label value HIDEG H970474X;
label value HISPANX H970475X;
label value HISPCAT H970476X;
label value HLTHLF42 H970477X;
label value HOMEBH42 H970478X;
label value HOUR31 H970479X;
label value HOUR42 H970480X;
label value HOUR53 H970481X;
label value HPDAP05 H970482X;
label value HPDAU05 H970483X;
label value HPDDE05 H970484X;
label value HPDFE05 H970485X;
label value HPDJA05 H970486X;
label value HPDJL05 H970487X;
label value HPDJU05 H970488X;
label value HPDMA05 H970489X;
label value HPDMY05 H970490X;
label value HPDNO05 H970491X;
label value HPDOC05 H970492X;
label value HPDSE05 H970493X;
label value HPEAP05 H970494X;
label value HPEAU05 H970495X;
label value HPEDE05 H970496X;
label value HPEFE05 H970497X;
label value HPEJA05 H970498X;
label value HPEJL05 H970499X;
label value HPEJU05 H970500X;
label value HPEMA05 H970501X;
label value HPEMY05 H970502X;
label value HPENO05 H970503X;
label value HPEOC05 H970504X;
label value HPESE05 H970505X;
label value HPNAP05 H970506X;
label value HPNAU05 H970507X;
label value HPNDE05 H970508X;
label value HPNFE05 H970509X;
label value HPNJA05 H970510X;
label value HPNJL05 H970511X;
label value HPNJU05 H970512X;
label value HPNMA05 H970513X;
label value HPNMY05 H970514X;
label value HPNNO05 H970515X;
label value HPNOC05 H970516X;
label value HPNSE05 H970517X;
label value HPOAP05 H970518X;
label value HPOAU05 H970519X;
label value HPODE05 H970520X;
label value HPOFE05 H970521X;
label value HPOJA05 H970522X;
label value HPOJL05 H970523X;
label value HPOJU05 H970524X;
label value HPOMA05 H970525X;
label value HPOMY05 H970526X;
label value HPONO05 H970527X;
label value HPOOC05 H970528X;
label value HPOSE05 H970529X;
label value HPRAP05 H970530X;
label value HPRAU05 H970531X;
label value HPRDE05 H970532X;
label value HPRFE05 H970533X;
label value HPRJA05 H970534X;
label value HPRJL05 H970535X;
label value HPRJU05 H970536X;
label value HPRMA05 H970537X;
label value HPRMY05 H970538X;
label value HPRNO05 H970539X;
label value HPROC05 H970540X;
label value HPRSE05 H970541X;
label value HPSAP05 H970542X;
label value HPSAU05 H970543X;
label value HPSDE05 H970544X;
label value HPSFE05 H970545X;
label value HPSJA05 H970546X;
label value HPSJL05 H970547X;
label value HPSJU05 H970548X;
label value HPSMA05 H970549X;
label value HPSMY05 H970550X;
label value HPSNO05 H970551X;
label value HPSOC05 H970552X;
label value HPSSE05 H970553X;
label value HRHOW31 H970554X;
label value HRHOW42 H970555X;
label value HRHOW53 H970556X;
label value HRWG31X H970557X;
label value HRWG42X H970558X;
label value HRWG53X H970559X;
label value HRWGIM31 H970560X;
label value HRWGIM42 H970561X;
label value HRWGIM53 H970562X;
label value HSELIM31 H970563X;
label value HSELIM53 H970564X;
label value HSPLAP42 H970565X;
label value HYSTER53 H970566X;
label value IADL3M31 H970567X;
label value IADL3M42 H970568X;
label value IADL3M53 H970569X;
label value IADLHP31 H970570X;
label value IADLHP42 H970571X;
label value IADLHP53 H970572X;
label value INDCAT31 H970573X;
label value INDCAT42 H970574X;
label value INDCAT53 H970575X;
label value INS05X H970576X;
label value INS31X H970577X;
label value INS42X H970578X;
label value INS53X H970579X;
label value INSAP05X H970580X;
label value INSAT05X H970581X;
label value INSAT31X H970582X;
label value INSAT42X H970583X;
label value INSAT53X H970584X;
label value INSAU05X H970585X;
label value INSC1231 H970586X;
label value INSCOP05 H970587X;
label value INSCOP31 H970588X;
label value INSCOP42 H970589X;
label value INSCOP53 H970590X;
label value INSCOPE H970591X;
label value INSCOV05 H970592X;
label value INSDE05X H970593X;
label value INSENDMM H970594X;
label value INSENDYY H970595X;
label value INSFE05X H970596X;
label value INSJA05X H970597X;
label value INSJL05X H970598X;
label value INSJU05X H970599X;
label value INSMA05X H970600X;
label value INSMY05X H970601X;
label value INSNO05X H970602X;
label value INSOC05X H970603X;
label value INSRPL42 H970604X;
label value INSSE05X H970605X;
label value INTIMP05 H970606X;
label value INTRP05X H970607X;
label value INTVLANG H970608X;
label value IPDEXP05 H970609X;
label value IPDIS05 H970610X;
label value IPDMCD05 H970611X;
label value IPDMCR05 H970612X;
label value IPDOFD05 H970613X;
label value IPDOPR05 H970614X;
label value IPDOPU05 H970615X;
label value IPDOSR05 H970616X;
label value IPDPRV05 H970617X;
label value IPDSLF05 H970618X;
label value IPDSTL05 H970619X;
label value IPDTCH05 H970620X;
label value IPDTRI05 H970621X;
label value IPDVA05 H970622X;
label value IPDWCP05 H970623X;
label value IPFEXP05 H970624X;
label value IPFMCD05 H970625X;
label value IPFMCR05 H970626X;
label value IPFOFD05 H970627X;
label value IPFOPR05 H970628X;
label value IPFOPU05 H970629X;
label value IPFOSR05 H970630X;
label value IPFPRV05 H970631X;
label value IPFSLF05 H970632X;
label value IPFSTL05 H970633X;
label value IPFTCH05 H970634X;
label value IPFTRI05 H970635X;
label value IPFVA05 H970636X;
label value IPFWCP05 H970637X;
label value IPNGTD05 H970638X;
label value IPZERO05 H970639X;
label value IRAIMP05 H970640X;
label value IRASP05X H970641X;
label value JNTPID05 H970642X;
label value JOBORG31 H970643X;
label value JOBORG42 H970644X;
label value JOBORG53 H970645X;
label value JOBRSN42 H970646X;
label value JTINRU05 H970647X;
label value JTPAIN53 H970648X;
label value K6SUM42 H970649X;
label value KEYNESS H970650X;
label value KIDPRO42 H970651X;
label value KNOWDR42 H970652X;
label value LANGHM42 H970653X;
label value LANGPR42 H970654X;
label value LAPBLT42 H970655X;
label value LFTDIF31 H970656X;
label value LFTDIF53 H970657X;
label value LKINFM42 H970658X;
label value LKINFT42 H970659X;
label value LOCATN42 H970660X;
label value LSHLTH42 H970661X;
label value LSTETH53 H970662X;
label value MAMOGR53 H970663X;
label value MARRY05X H970664X;
label value MARRY31X H970665X;
label value MARRY42X H970666X;
label value MARRY53X H970667X;
label value MCAID05 H970668X;
label value MCAID05X H970669X;
label value MCAID31 H970670X;
label value MCAID31X H970671X;
label value MCAID42 H970672X;
label value MCAID42X H970673X;
label value MCAID53 H970674X;
label value MCAID53X H970675X;
label value MCARE05 H970676X;
label value MCARE05X H970677X;
label value MCARE31 H970678X;
label value MCARE31X H970679X;
label value MCARE42 H970680X;
label value MCARE42X H970681X;
label value MCARE53 H970682X;
label value MCARE53X H970683X;
label value MCDAP05 H970684X;
label value MCDAP05X H970685X;
label value MCDAT05X H970686X;
label value MCDAT31X H970687X;
label value MCDAT42X H970688X;
label value MCDAT53X H970689X;
label value MCDAU05 H970690X;
label value MCDAU05X H970691X;
label value MCDDE05 H970692X;
label value MCDDE05X H970693X;
label value MCDEV05 H970694X;
label value MCDFE05 H970695X;
label value MCDFE05X H970696X;
label value MCDHMO05 H970697X;
label value MCDHMO31 H970698X;
label value MCDHMO42 H970699X;
label value MCDJA05 H970700X;
label value MCDJA05X H970701X;
label value MCDJL05 H970702X;
label value MCDJL05X H970703X;
label value MCDJU05 H970704X;
label value MCDJU05X H970705X;
label value MCDMA05 H970706X;
label value MCDMA05X H970707X;
label value MCDMC05 H970708X;
label value MCDMC31 H970709X;
label value MCDMC42 H970710X;
label value MCDMY05 H970711X;
label value MCDMY05X H970712X;
label value MCDNO05 H970713X;
label value MCDNO05X H970714X;
label value MCDOC05 H970715X;
label value MCDOC05X H970716X;
label value MCDSE05 H970717X;
label value MCDSE05X H970718X;
label value MCRAP05 H970719X;
label value MCRAP05X H970720X;
label value MCRAU05 H970721X;
label value MCRAU05X H970722X;
label value MCRDE05 H970723X;
label value MCRDE05X H970724X;
label value MCREV05 H970725X;
label value MCRFE05 H970726X;
label value MCRFE05X H970727X;
label value MCRJA05 H970728X;
label value MCRJA05X H970729X;
label value MCRJL05 H970730X;
label value MCRJL05X H970731X;
label value MCRJU05 H970732X;
label value MCRJU05X H970733X;
label value MCRMA05 H970734X;
label value MCRMA05X H970735X;
label value MCRMY05 H970736X;
label value MCRMY05X H970737X;
label value MCRNO05 H970738X;
label value MCRNO05X H970739X;
label value MCROC05 H970740X;
label value MCROC05X H970741X;
label value MCRSE05 H970742X;
label value MCRSE05X H970743X;
label value MCS42 H970744X;
label value MDDLAY42 H970745X;
label value MDDLPR42 H970746X;
label value MDDLRS42 H970747X;
label value MDUNAB42 H970748X;
label value MDUNPR42 H970749X;
label value MDUNRS42 H970750X;
label value MESBPR42 H970751X;
label value MESHGT42 H970752X;
label value MESVIS42 H970753X;
label value MESWGT42 H970754X;
label value MIDX53 H970755X;
label value MILDIF31 H970756X;
label value MILDIF53 H970757X;
label value MINORP42 H970758X;
label value MNHLTH31 H970759X;
label value MNHLTH42 H970760X;
label value MNHLTH53 H970761X;
label value MOMPRO42 H970762X;
label value MORE31 H970763X;
label value MORE42 H970764X;
label value MORE53 H970765X;
label value MORECOVR H970766X;
label value MORJOB31 H970767X;
label value MORJOB42 H970768X;
label value MORJOB53 H970769X;
label value MSA05 H970770X;
label value MSA31 H970771X;
label value MSA42 H970772X;
label value MSA53 H970773X;
label value MYSELF42 H970774X;
label value NATAMP42 H970775X;
label value NERVAF42 H970776X;
label value NEVILL42 H970777X;
label value NEWARE42 H970778X;
label value NEWDOC42 H970779X;
label value NHRWG31 H970780X;
label value NHRWG42 H970781X;
label value NHRWG53 H970782X;
label value NOASPR53 H970783X;
label value NOFAT53 H970784X;
label value NOGODR42 H970785X;
label value NOINSBEF H970786X;
label value NOINSTM H970787X;
label value NOINUNIT H970788X;
label value NOLIKE42 H970789X;
label value NOREAS42 H970790X;
label value NOSMOK42 H970791X;
label value NUMEMP31 H970792X;
label value NUMEMP42 H970793X;
label value NUMEMP53 H970794X;
label value NURSE53 H970795X;
label value NWK31 H970796X;
label value NWK42 H970797X;
label value NWK53 H970798X;
label value OBAEXP05 H970799X;
label value OBAMCD05 H970800X;
label value OBAMCR05 H970801X;
label value OBAOFD05 H970802X;
label value OBAOPR05 H970803X;
label value OBAOPU05 H970804X;
label value OBAOSR05 H970805X;
label value OBAPRV05 H970806X;
label value OBASLF05 H970807X;
label value OBASST05 H970808X;
label value OBASTL05 H970809X;
label value OBATCH05 H970810X;
label value OBATRI05 H970811X;
label value OBAVA05 H970812X;
label value OBAWCP05 H970813X;
label value OBCEXP05 H970814X;
label value OBCHIR05 H970815X;
label value OBCMCD05 H970816X;
label value OBCMCR05 H970817X;
label value OBCOFD05 H970818X;
label value OBCOPR05 H970819X;
label value OBCOPU05 H970820X;
label value OBCOSR05 H970821X;
label value OBCPRV05 H970822X;
label value OBCSLF05 H970823X;
label value OBCSTL05 H970824X;
label value OBCTCH05 H970825X;
label value OBCTRI05 H970826X;
label value OBCVA05 H970827X;
label value OBCWCP05 H970828X;
label value OBDEXP05 H970829X;
label value OBDMCD05 H970830X;
label value OBDMCR05 H970831X;
label value OBDOFD05 H970832X;
label value OBDOPR05 H970833X;
label value OBDOPU05 H970834X;
label value OBDOSR05 H970835X;
label value OBDPRV05 H970836X;
label value OBDRV05 H970837X;
label value OBDSLF05 H970838X;
label value OBDSTL05 H970839X;
label value OBDTCH05 H970840X;
label value OBDTRI05 H970841X;
label value OBDVA05 H970842X;
label value OBDWCP05 H970843X;
label value OBEEXP05 H970844X;
label value OBEMCD05 H970845X;
label value OBEMCR05 H970846X;
label value OBEOFD05 H970847X;
label value OBEOPR05 H970848X;
label value OBEOPU05 H970849X;
label value OBEOSR05 H970850X;
label value OBEPRV05 H970851X;
label value OBESLF05 H970852X;
label value OBESTL05 H970853X;
label value OBETCH05 H970854X;
label value OBETRI05 H970855X;
label value OBEVA05 H970856X;
label value OBEWCP05 H970857X;
label value OBNEXP05 H970858X;
label value OBNMCD05 H970859X;
label value OBNMCR05 H970860X;
label value OBNOFD05 H970861X;
label value OBNOPR05 H970862X;
label value OBNOPU05 H970863X;
label value OBNOSR05 H970864X;
label value OBNPRV05 H970865X;
label value OBNSLF05 H970866X;
label value OBNSTL05 H970867X;
label value OBNTCH05 H970868X;
label value OBNTRI05 H970869X;
label value OBNURS05 H970870X;
label value OBNVA05 H970871X;
label value OBNWCP05 H970872X;
label value OBOEXP05 H970873X;
label value OBOMCD05 H970874X;
label value OBOMCR05 H970875X;
label value OBOOFD05 H970876X;
label value OBOOPR05 H970877X;
label value OBOOPU05 H970878X;
label value OBOOSR05 H970879X;
label value OBOPRV05 H970880X;
label value OBOPTO05 H970881X;
label value OBOSLF05 H970882X;
label value OBOSTL05 H970883X;
label value OBOTCH05 H970884X;
label value OBOTHV05 H970885X;
label value OBOTRI05 H970886X;
label value OBOVA05 H970887X;
label value OBOWCP05 H970888X;
label value OBTEXP05 H970889X;
label value OBTHER05 H970890X;
label value OBTMCD05 H970891X;
label value OBTMCR05 H970892X;
label value OBTOFD05 H970893X;
label value OBTOPR05 H970894X;
label value OBTOPU05 H970895X;
label value OBTOSR05 H970896X;
label value OBTOTV05 H970897X;
label value OBTPRV05 H970898X;
label value OBTSLF05 H970899X;
label value OBTSTL05 H970900X;
label value OBTTCH05 H970901X;
label value OBTTRI05 H970902X;
label value OBTVA05 H970903X;
label value OBTWCP05 H970904X;
label value OBVEXP05 H970905X;
label value OBVMCD05 H970906X;
label value OBVMCR05 H970907X;
label value OBVOFD05 H970908X;
label value OBVOPR05 H970909X;
label value OBVOPU05 H970910X;
label value OBVOSR05 H970911X;
label value OBVPRV05 H970912X;
label value OBVSLF05 H970913X;
label value OBVSTL05 H970914X;
label value OBVTCH05 H970915X;
label value OBVTRI05 H970916X;
label value OBVVA05 H970917X;
label value OBVWCP05 H970918X;
label value OCCCAT31 H970919X;
label value OCCCAT42 H970920X;
label value OCCCAT53 H970921X;
label value OFFER31X H970922X;
label value OFFER42X H970923X;
label value OFFER53X H970924X;
label value OFFHOU42 H970925X;
label value OFREMP31 H970926X;
label value OFREMP42 H970927X;
label value OFREMP53 H970928X;
label value OHRTDX53 H970929X;
label value ONGONG42 H970930X;
label value ONJOB42 H970931X;
label value OPAAP05 H970932X;
label value OPAAU05 H970933X;
label value OPADE05 H970934X;
label value OPAEV05 H970935X;
label value OPAFE05 H970936X;
label value OPAJA05 H970937X;
label value OPAJL05 H970938X;
label value OPAJU05 H970939X;
label value OPAMA05 H970940X;
label value OPAMY05 H970941X;
label value OPANO05 H970942X;
label value OPAOC05 H970943X;
label value OPASE05 H970944X;
label value OPBAP05 H970945X;
label value OPBAU05 H970946X;
label value OPBDE05 H970947X;
label value OPBEV05 H970948X;
label value OPBFE05 H970949X;
label value OPBJA05 H970950X;
label value OPBJL05 H970951X;
label value OPBJU05 H970952X;
label value OPBMA05 H970953X;
label value OPBMY05 H970954X;
label value OPBNO05 H970955X;
label value OPBOC05 H970956X;
label value OPBSE05 H970957X;
label value OPDEXP05 H970958X;
label value OPDMCD05 H970959X;
label value OPDMCR05 H970960X;
label value OPDOFD05 H970961X;
label value OPDOPR05 H970962X;
label value OPDOPU05 H970963X;
label value OPDOSR05 H970964X;
label value OPDPRV05 H970965X;
label value OPDRV05 H970966X;
label value OPDSLF05 H970967X;
label value OPDSTL05 H970968X;
label value OPDTCH05 H970969X;
label value OPDTRI05 H970970X;
label value OPDVA05 H970971X;
label value OPDWCP05 H970972X;
label value OPFEXP05 H970973X;
label value OPFMCD05 H970974X;
label value OPFMCR05 H970975X;
label value OPFOFD05 H970976X;
label value OPFOPR05 H970977X;
label value OPFOPU05 H970978X;
label value OPFOSR05 H970979X;
label value OPFPRV05 H970980X;
label value OPFSLF05 H970981X;
label value OPFSTL05 H970982X;
label value OPFTCH05 H970983X;
label value OPFTRI05 H970984X;
label value OPFVA05 H970985X;
label value OPFWCP05 H970986X;
label value OPOEXP05 H970987X;
label value OPOMCD05 H970988X;
label value OPOMCR05 H970989X;
label value OPOOFD05 H970990X;
label value OPOOPR05 H970991X;
label value OPOOPU05 H970992X;
label value OPOOSR05 H970993X;
label value OPOPRV05 H970994X;
label value OPOSLF05 H970995X;
label value OPOSTL05 H970996X;
label value OPOTCH05 H970997X;
label value OPOTHV05 H970998X;
label value OPOTRI05 H970999X;
label value OPOVA05 H971000X;
label value OPOWCP05 H971001X;
label value OPPEXP05 H971002X;
label value OPPMCD05 H971003X;
label value OPPMCR05 H971004X;
label value OPPOFD05 H971005X;
label value OPPOPR05 H971006X;
label value OPPOPU05 H971007X;
label value OPPOSR05 H971008X;
label value OPPPRV05 H971009X;
label value OPPSLF05 H971010X;
label value OPPSTL05 H971011X;
label value OPPTCH05 H971012X;
label value OPPTRI05 H971013X;
label value OPPVA05 H971014X;
label value OPPWCP05 H971015X;
label value OPSEXP05 H971016X;
label value OPSMCD05 H971017X;
label value OPSMCR05 H971018X;
label value OPSOFD05 H971019X;
label value OPSOPR05 H971020X;
label value OPSOPU05 H971021X;
label value OPSOSR05 H971022X;
label value OPSPRV05 H971023X;
label value OPSSLF05 H971024X;
label value OPSSTL05 H971025X;
label value OPSTCH05 H971026X;
label value OPSTRI05 H971027X;
label value OPSVA05 H971028X;
label value OPSWCP05 H971029X;
label value OPTOTV05 H971030X;
label value OPVEXP05 H971031X;
label value OPVMCD05 H971032X;
label value OPVMCR05 H971033X;
label value OPVOFD05 H971034X;
label value OPVOPR05 H971035X;
label value OPVOPU05 H971036X;
label value OPVOSR05 H971037X;
label value OPVPRV05 H971038X;
label value OPVSLF05 H971039X;
label value OPVSTL05 H971040X;
label value OPVTCH05 H971041X;
label value OPVTRI05 H971042X;
label value OPVVA05 H971043X;
label value OPVWCP05 H971044X;
label value OTHDYS31 H971045X;
label value OTHDYS42 H971046X;
label value OTHDYS53 H971047X;
label value OTHEXP05 H971048X;
label value OTHIMP05 H971049X;
label value OTHINS42 H971050X;
label value OTHMCD05 H971051X;
label value OTHMCR05 H971052X;
label value OTHNDD31 H971053X;
label value OTHNDD42 H971054X;
label value OTHNDD53 H971055X;
label value OTHOFD05 H971056X;
label value OTHOPR05 H971057X;
label value OTHOPU05 H971058X;
label value OTHOSR05 H971059X;
label value OTHPRV05 H971060X;
label value OTHRCP42 H971061X;
label value OTHREA42 H971062X;
label value OTHRP05X H971063X;
label value OTHSLF05 H971064X;
label value OTHSTL05 H971065X;
label value OTHTCH05 H971066X;
label value OTHTRI05 H971067X;
label value OTHVA05 H971068X;
label value OTHWCP05 H971069X;
label value OTPAAT05 H971070X;
label value OTPAAT31 H971071X;
label value OTPAAT42 H971072X;
label value OTPAAT53 H971073X;
label value OTPBAT05 H971074X;
label value OTPBAT31 H971075X;
label value OTPBAT42 H971076X;
label value OTPBAT53 H971077X;
label value OTPUBA05 H971078X;
label value OTPUBA31 H971079X;
label value OTPUBA42 H971080X;
label value OTPUBA53 H971081X;
label value OTPUBB05 H971082X;
label value OTPUBB31 H971083X;
label value OTPUBB42 H971084X;
label value OTPUBB53 H971085X;
label value PACISP42 H971086X;
label value PANEL H971087X;
label value PAPSMR53 H971088X;
label value PAYDR31 H971089X;
label value PAYDR42 H971090X;
label value PAYDR53 H971091X;
label value PAYVAC31 H971092X;
label value PAYVAC42 H971093X;
label value PAYVAC53 H971094X;
label value PBINFM42 H971095X;
label value PBINFT42 H971096X;
label value PBPWKM42 H971097X;
label value PBPWKT42 H971098X;
label value PBSVCM42 H971099X;
label value PBSVCT42 H971100X;
label value PDKAP05 H971101X;
label value PDKAU05 H971102X;
label value PDKDE05 H971103X;
label value PDKFE05 H971104X;
label value PDKJA05 H971105X;
label value PDKJL05 H971106X;
label value PDKJU05 H971107X;
label value PDKMA05 H971108X;
label value PDKMY05 H971109X;
label value PDKNO05 H971110X;
label value PDKOC05 H971111X;
label value PDKSE05 H971112X;
label value PEGAP05 H971113X;
label value PEGAU05 H971114X;
label value PEGDE05 H971115X;
label value PEGFE05 H971116X;
label value PEGJA05 H971117X;
label value PEGJL05 H971118X;
label value PEGJU05 H971119X;
label value PEGMA05 H971120X;
label value PEGMY05 H971121X;
label value PEGNO05 H971122X;
label value PEGOC05 H971123X;
label value PEGSE05 H971124X;
label value PENIMP05 H971125X;
label value PENSP05X H971126X;
label value PERSLA42 H971127X;
label value PHMONP05 H971128X;
label value PHMONP31 H971129X;
label value PHMONP42 H971130X;
label value PHNREG42 H971131X;
label value PHONE53 H971132X;
label value PHQ242 H971133X;
label value PHYACT53 H971134X;
label value PHYSCL42 H971135X;
label value PLCTYP42 H971136X;
label value PMDLAY42 H971137X;
label value PMDLPR42 H971138X;
label value PMDLRS42 H971139X;
label value PMEDIN31 H971140X;
label value PMEDIN42 H971141X;
label value PMEDIN53 H971142X;
label value PMEDPY31 H971143X;
label value PMEDPY42 H971144X;
label value PMEDPY53 H971145X;
label value PMEDUP31 H971146X;
label value PMEDUP42 H971147X;
label value PMEDUP53 H971148X;
label value PMNCNP05 H971149X;
label value PMNCNP31 H971150X;
label value PMNCNP42 H971151X;
label value PMUNAB42 H971152X;
label value PMUNPR42 H971153X;
label value PMUNRS42 H971154X;
label value PNGAP05 H971155X;
label value PNGAU05 H971156X;
label value PNGDE05 H971157X;
label value PNGFE05 H971158X;
label value PNGJA05 H971159X;
label value PNGJL05 H971160X;
label value PNGJU05 H971161X;
label value PNGMA05 H971162X;
label value PNGMY05 H971163X;
label value PNGNO05 H971164X;
label value PNGOC05 H971165X;
label value PNGSE05 H971166X;
label value POGAP05 H971167X;
label value POGAU05 H971168X;
label value POGDE05 H971169X;
label value POGFE05 H971170X;
label value POGJA05 H971171X;
label value POGJL05 H971172X;
label value POGJU05 H971173X;
label value POGMA05 H971174X;
label value POGMY05 H971175X;
label value POGNO05 H971176X;
label value POGOC05 H971177X;
label value POGSE05 H971178X;
label value POUAP05 H971179X;
label value POUAU05 H971180X;
label value POUDE05 H971181X;
label value POUFE05 H971182X;
label value POUJA05 H971183X;
label value POUJL05 H971184X;
label value POUJU05 H971185X;
label value POUMA05 H971186X;
label value POUMY05 H971187X;
label value POUNO05 H971188X;
label value POUOC05 H971189X;
label value POUSE05 H971190X;
label value POVCAT05 H971191X;
label value PPRWKM42 H971192X;
label value PPRWKT42 H971193X;
label value PRDRNP05 H971194X;
label value PRDRNP31 H971195X;
label value PRDRNP42 H971196X;
label value PREVCOVR H971197X;
label value PREVEN42 H971198X;
label value PRIAP05 H971199X;
label value PRIAU05 H971200X;
label value PRIDE05 H971201X;
label value PRIDK05 H971202X;
label value PRIDK31 H971203X;
label value PRIDK42 H971204X;
label value PRIDK53 H971205X;
label value PRIEU05 H971206X;
label value PRIEU31 H971207X;
label value PRIEU42 H971208X;
label value PRIEU53 H971209X;
label value PRIFE05 H971210X;
label value PRIJA05 H971211X;
label value PRIJL05 H971212X;
label value PRIJU05 H971213X;
label value PRIMA05 H971214X;
label value PRIMY05 H971215X;
label value PRING05 H971216X;
label value PRING31 H971217X;
label value PRING42 H971218X;
label value PRING53 H971219X;
label value PRINO05 H971220X;
label value PRIOC05 H971221X;
label value PRIOG05 H971222X;
label value PRIOG31 H971223X;
label value PRIOG42 H971224X;
label value PRIOG53 H971225X;
label value PRIS05 H971226X;
label value PRIS31 H971227X;
label value PRIS42 H971228X;
label value PRIS53 H971229X;
label value PRISE05 H971230X;
label value PRIV05 H971231X;
label value PRIV31 H971232X;
label value PRIV42 H971233X;
label value PRIV53 H971234X;
label value PRIVAT05 H971235X;
label value PRIVAT31 H971236X;
label value PRIVAT42 H971237X;
label value PRIVAT53 H971238X;
label value PROUT05 H971239X;
label value PROUT31 H971240X;
label value PROUT42 H971241X;
label value PROUT53 H971242X;
label value PROVTY42 H971243X;
label value PROXY05 H971244X;
label value PROXY31 H971245X;
label value PROXY42 H971246X;
label value PROXY53 H971247X;
label value PRSAP05 H971248X;
label value PRSAU05 H971249X;
label value PRSDE05 H971250X;
label value PRSFE05 H971251X;
label value PRSJA05 H971252X;
label value PRSJL05 H971253X;
label value PRSJU05 H971254X;
label value PRSMA05 H971255X;
label value PRSMY05 H971256X;
label value PRSNO05 H971257X;
label value PRSOC05 H971258X;
label value PRSSE05 H971259X;
label value PRVDRL05 H971260X;
label value PRVDRL31 H971261X;
label value PRVDRL42 H971262X;
label value PRVEV05 H971263X;
label value PRVHMO05 H971264X;
label value PRVHMO31 H971265X;
label value PRVHMO42 H971266X;
label value PRVMNC05 H971267X;
label value PRVMNC31 H971268X;
label value PRVMNC42 H971269X;
label value PSA53 H971270X;
label value PSTATS31 H971271X;
label value PSTATS42 H971272X;
label value PSTATS53 H971273X;
label value PUB05X H971274X;
label value PUB31X H971275X;
label value PUB42X H971276X;
label value PUB53X H971277X;
label value PUBAP05X H971278X;
label value PUBAT05X H971279X;
label value PUBAT31X H971280X;
label value PUBAT42X H971281X;
label value PUBAT53X H971282X;
label value PUBAU05X H971283X;
label value PUBDE05X H971284X;
label value PUBFE05X H971285X;
label value PUBIMP05 H971286X;
label value PUBJA05X H971287X;
label value PUBJL05X H971288X;
label value PUBJU05X H971289X;
label value PUBMA05X H971290X;
label value PUBMY05X H971291X;
label value PUBNO05X H971292X;
label value PUBOC05X H971293X;
label value PUBP05X H971294X;
label value PUBSE05X H971295X;
label value RACEAX H971296X;
label value RACEBX H971297X;
label value RACETHNX H971298X;
label value RACEWX H971299X;
label value RACEX H971300X;
label value RCHDIF31 H971301X;
label value RCHDIF53 H971302X;
label value READNW42 H971303X;
label value RECPEP42 H971304X;
label value REFDP05X H971305X;
label value REFER53 H971306X;
label value REFFRL42 H971307X;
label value REFIMP05 H971308X;
label value REGION05 H971309X;
label value REGION31 H971310X;
label value REGION42 H971311X;
label value REGION53 H971312X;
label value RESP05 H971313X;
label value RESP31 H971314X;
label value RESP42 H971315X;
label value RESP53 H971316X;
label value RESPCT42 H971317X;
label value RETPLN31 H971318X;
label value RETPLN42 H971319X;
label value RETPLN53 H971320X;
label value RFREL05X H971321X;
label value RFREL31X H971322X;
label value RFREL42X H971323X;
label value RFREL53X H971324X;
label value RNDFLG31 H971325X;
label value RTHLTH31 H971326X;
label value RTHLTH42 H971327X;
label value RTHLTH53 H971328X;
label value RTPLNM42 H971329X;
label value RTPLNT42 H971330X;
label value RUCLAS05 H971331X;
label value RUCLAS31 H971332X;
label value RUCLAS42 H971333X;
label value RUCLAS53 H971334X;
label value RUSIZE05 H971335X;
label value RUSIZE31 H971336X;
label value RUSIZE42 H971337X;
label value RUSIZE53 H971338X;
label value RXEXP05 H971339X;
label value RXMCD05 H971340X;
label value RXMCR05 H971341X;
label value RXOFD05 H971342X;
label value RXOPR05 H971343X;
label value RXOPU05 H971344X;
label value RXOSR05 H971345X;
label value RXPRV05 H971346X;
label value RXSLF05 H971347X;
label value RXSTL05 H971348X;
label value RXTOT05 H971349X;
label value RXTRI05 H971350X;
label value RXVA05 H971351X;
label value RXWCP05 H971352X;
label value SAFEST42 H971353X;
label value SALIMP05 H971354X;
label value SAQELIG H971355X;
label value SCHLBH42 H971356X;
label value SCHLIM31 H971357X;
label value SCHLIM53 H971358X;
label value SCHPRO42 H971359X;
label value SCLNBD31 H971360X;
label value SCLNBD42 H971361X;
label value SCLNBD53 H971362X;
label value SEATBE53 H971363X;
label value SEEDIF42 H971364X;
label value SELDSI42 H971365X;
label value SELFCM31 H971366X;
label value SELFCM42 H971367X;
label value SELFCM53 H971368X;
label value SEX H971369X;
label value SFFLAG42 H971370X;
label value SIBPRO42 H971371X;
label value SICEAS42 H971372X;
label value SICPAY31 H971373X;
label value SICPAY42 H971374X;
label value SICPAY53 H971375X;
label value SOCLIM31 H971376X;
label value SOCLIM53 H971377X;
label value SPOUID05 H971378X;
label value SPOUID31 H971379X;
label value SPOUID42 H971380X;
label value SPOUID53 H971381X;
label value SPOUIN05 H971382X;
label value SPOUIN31 H971383X;
label value SPOUIN42 H971384X;
label value SPOUIN53 H971385X;
label value SPRPRO42 H971386X;
label value SRTHRT53 H971387X;
label value SSCIMP05 H971388X;
label value SSECP05X H971389X;
label value SSIDIS05 H971390X;
label value SSIIMP05 H971391X;
label value SSIP05X H971392X;
label value SSNLJB31 H971393X;
label value SSNLJB42 H971394X;
label value SSNLJB53 H971395X;
label value STAAP05 H971396X;
label value STAAU05 H971397X;
label value STADE05 H971398X;
label value STAFE05 H971399X;
label value STAJA05 H971400X;
label value STAJL05 H971401X;
label value STAJU05 H971402X;
label value STAMA05 H971403X;
label value STAMY05 H971404X;
label value STANO05 H971405X;
label value STAOC05 H971406X;
label value STAPR05 H971407X;
label value STAPR31 H971408X;
label value STAPR42 H971409X;
label value STAPR53 H971410X;
label value STASE05 H971411X;
label value STJBDD31 H971412X;
label value STJBDD42 H971413X;
label value STJBDD53 H971414X;
label value STJBMM31 H971415X;
label value STJBMM42 H971416X;
label value STJBMM53 H971417X;
label value STJBYY31 H971418X;
label value STJBYY42 H971419X;
label value STJBYY53 H971420X;
label value STNDIF31 H971421X;
label value STNDIF53 H971422X;
label value STOMCH53 H971423X;
label value STOOL53 H971424X;
label value STPDIF31 H971425X;
label value STPDIF53 H971426X;
label value STPRAT05 H971427X;
label value STPRAT31 H971428X;
label value STPRAT42 H971429X;
label value STPRAT53 H971430X;
label value STRKDX53 H971431X;
label value TAXFRM05 H971432X;
label value TEMPJB31 H971433X;
label value TEMPJB42 H971434X;
label value TEMPJB53 H971435X;
label value THANTB53 H971436X;
label value THANTF53 H971437X;
label value THSWAB53 H971438X;
label value THSWBF53 H971439X;
label value THSYMF53 H971440X;
label value THSYMP53 H971441X;
label value TIMALN42 H971442X;
label value TMTKUS42 H971443X;
label value TOTDED05 H971444X;
label value TOTEXP05 H971445X;
label value TOTMCD05 H971446X;
label value TOTMCR05 H971447X;
label value TOTOFD05 H971448X;
label value TOTOPR05 H971449X;
label value TOTOPU05 H971450X;
label value TOTOSR05 H971451X;
label value TOTPRV05 H971452X;
label value TOTSLF05 H971453X;
label value TOTSTL05 H971454X;
label value TOTTCH05 H971455X;
label value TOTTRI05 H971456X;
label value TOTVA05 H971457X;
label value TOTWCP05 H971458X;
label value TRANS42 H971459X;
label value TRBLE42 H971460X;
label value TREATM42 H971461X;
label value TRIAP05X H971462X;
label value TRIAT05X H971463X;
label value TRIAT31X H971464X;
label value TRIAT42X H971465X;
label value TRIAT53X H971466X;
label value TRIAU05X H971467X;
label value TRICH05X H971468X;
label value TRICH42X H971469X;
label value TRICR05X H971470X;
label value TRICR31X H971471X;
label value TRICR42X H971472X;
label value TRICR53X H971473X;
label value TRIDE05X H971474X;
label value TRIEV05 H971475X;
label value TRIEX05X H971476X;
label value TRIEX31X H971477X;
label value TRIEX42X H971478X;
label value TRIFE05X H971479X;
label value TRIJA05X H971480X;
label value TRIJL05X H971481X;
label value TRIJU05X H971482X;
label value TRILI05X H971483X;
label value TRILI31X H971484X;
label value TRILI42X H971485X;
label value TRIMA05X H971486X;
label value TRIMY05X H971487X;
label value TRINO05X H971488X;
label value TRIOC05X H971489X;
label value TRIPR05X H971490X;
label value TRIPR31X H971491X;
label value TRIPR42X H971492X;
label value TRISE05X H971493X;
label value TRIST05X H971494X;
label value TRIST31X H971495X;
label value TRIST42X H971496X;
label value TRTIMP05 H971497X;
label value TTLP05X H971498X;
label value TYPEPE42 H971499X;
label value UNABLE31 H971500X;
label value UNABLE53 H971501X;
label value UNEIMP05 H971502X;
label value UNEMP05X H971503X;
label value UNHAP42 H971504X;
label value UNINS05 H971505X;
label value UNION31 H971506X;
label value UNION42 H971507X;
label value UNION53 H971508X;
label value USCNOT42 H971509X;
label value VETIMP05 H971510X;
label value VETSP05X H971511X;
label value VISEXP05 H971512X;
label value VISION42 H971513X;
label value VISIT53 H971514X;
label value VISMCD05 H971515X;
label value VISMCR05 H971516X;
label value VISOFD05 H971517X;
label value VISOPR05 H971518X;
label value VISOPU05 H971519X;
label value VISOSR05 H971520X;
label value VISPRV05 H971521X;
label value VISSLF05 H971522X;
label value VISSTL05 H971523X;
label value VISTCH05 H971524X;
label value VISTRI05 H971525X;
label value VISVA05 H971526X;
label value VISWCP05 H971527X;
label value WAGEP05X H971528X;
label value WAGIMP05 H971529X;
label value WASAFDC H971530X;
label value WASCHAMP H971531X;
label value WASESTB H971532X;
label value WASMCAID H971533X;
label value WASMCARE H971534X;
label value WASOTGOV H971535X;
label value WASOTHER H971536X;
label value WASPRIV H971537X;
label value WASSSI H971538X;
label value WASSTAT1 H971539X;
label value WASSTAT2 H971540X;
label value WASSTAT3 H971541X;
label value WASSTAT4 H971542X;
label value WASVA H971543X;
label value WCMPP05X H971544X;
label value WCPIMP05 H971545X;
label value WHENST53 H971546X;
label value WHITPR42 H971547X;
label value WHNBPR42 H971548X;
label value WHNBST42 H971549X;
label value WHNBWL53 H971550X;
label value WHNDEN42 H971551X;
label value WHNEAT42 H971552X;
label value WHNHEL42 H971553X;
label value WHNHGT42 H971554X;
label value WHNLAP42 H971555X;
label value WHNPHY42 H971556X;
label value WHNSAF42 H971557X;
label value WHNSMK42 H971558X;
label value WHNWGT42 H971559X;
label value WILFIL05 H971560X;
label value WKINBD31 H971561X;
label value WKINBD42 H971562X;
label value WKINBD53 H971563X;
label value WLK3MO31 H971564X;
label value WLK3MO53 H971565X;
label value WLKDIF31 H971566X;
label value WLKDIF53 H971567X;
label value WLKLIM31 H971568X;
label value WLKLIM53 H971569X;
label value WRGLAS42 H971570X;
label value WRHLTH42 H971571X;
label value WRKLIM31 H971572X;
label value WRKLIM53 H971573X;
label value YCHJ3142 H971574X;
label value YCHJ4253 H971575X;
label value YNOINS31 H971576X;
label value YNOINS42 H971577X;
label value YNOINS53 H971578X;
label value YNOUSC42 H971579X;
label value ZIDEXP05 H971580X;
label value ZIDMCD05 H971581X;
label value ZIDMCR05 H971582X;
label value ZIDOFD05 H971583X;
label value ZIDOPR05 H971584X;
label value ZIDOPU05 H971585X;
label value ZIDOSR05 H971586X;
label value ZIDPRV05 H971587X;
label value ZIDSLF05 H971588X;
label value ZIDSTL05 H971589X;
label value ZIDTCH05 H971590X;
label value ZIDTRI05 H971591X;
label value ZIDVA05 H971592X;
label value ZIDWCP05 H971593X;
label value ZIFEXP05 H971594X;
label value ZIFMCD05 H971595X;
label value ZIFMCR05 H971596X;
label value ZIFOFD05 H971597X;
label value ZIFOPR05 H971598X;
label value ZIFOPU05 H971599X;
label value ZIFOSR05 H971600X;
label value ZIFPRV05 H971601X;
label value ZIFSLF05 H971602X;
label value ZIFSTL05 H971603X;
label value ZIFTCH05 H971604X;
label value ZIFTRI05 H971605X;
label value ZIFVA05 H971606X;
label value ZIFWCP05 H971607X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H97.LOG and a data file named H97.DTA.  If these files (H97.DTA and H97.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

